/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Map;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="metavariableskill", aliases={"variableskill", "vskill"}, description="Finds and executes a metaskill")
public class MetaVariableSkillMechanic
extends SkillMechanic
implements IMetaSkill {
    protected PlaceholderString skillName;
    protected Map<String, String> parameters = Maps.newConcurrentMap();

    public MetaVariableSkillMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.target_creative = true;
        this.skillName = mlc.getPlaceholderString(new String[]{"skill", "s", "meta", "m", "mechanics", "$", "()"}, "", new String[0]);
        this.buildParameters(mlc);
    }

    @Override
    public SkillResult cast(SkillMetadata dataIn) {
        SkillMetadata data;
        String skillName = this.skillName.get(dataIn);
        Optional<Skill> maybeSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaVSkill {0} was not found", this.skillName);
            return SkillResult.INVALID_CONFIG;
        }
        Skill ms = maybeSkill.get();
        if (!ms.isUsable(dataIn)) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaSkill {0} is currently unusable", this.skillName);
            return SkillResult.CONDITION_FAILED;
        }
        if (!this.parameters.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Injecting {0} parameters", this.parameters.size());
            data = this.injectParameters(dataIn);
        } else {
            data = dataIn;
        }
        if (ConfigExecutor.debugLevel > 0) {
            if (data.getEntityTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaVSkill (et: {0}) -> {1}", data.getEntityTargets().size(), this.skillName);
            } else if (data.getLocationTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaVSkill (lt: {0}) -> {1}", data.getLocationTargets().size(), this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaVSkill (t: 0) -> {0}", this.skillName);
            }
        }
        if (this.forceSync && data.getIsAsync()) {
            data.setIsAsync(false);
            Schedulers.sync().run(() -> {
                data.setIsAsync(false);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Sync from MetaVSkillMechanic", this.skillName);
                ms.execute(data);
            });
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Async from MetaSkillMechanic", this.skillName);
            ms.execute(data);
        }
        return SkillResult.SUCCESS;
    }

    private void buildParameters(MythicLineConfig mlc) {
        if (!MythicBukkit.isVolatile()) {
            return;
        }
        block31: for (Map.Entry<String, String> entry : mlc.entrySet()) {
            switch (entry.getKey().toLowerCase()) {
                case "skill": 
                case "s": 
                case "meta": 
                case "m": 
                case "mechanics": 
                case "cooldown": 
                case "cd": 
                case "delay": 
                case "repeat": 
                case "targetinterval": 
                case "targeti": 
                case "repeatinterval": 
                case "repeati": 
                case "power": 
                case "powersplitbetweentargets": 
                case "powersplit": 
                case "splitpower": 
                case "forcesync": 
                case "sync": 
                case "targetisorigin": 
                case "sourceisorigin": 
                case "castfromorigin": 
                case "fromorigin": 
                case "fo": 
                case "origin": 
                case "targetcreative": {
                    continue block31;
                }
            }
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    private SkillMetadata injectParameters(SkillMetadata data) {
        data = data.deepClone();
        data.getParameters().putAll(this.parameters);
        return data;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

