/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Map;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="metaskill", aliases={"skill", "meta"}, description="Executes a metaskill")
public class MetaSkillMechanic
extends SkillMechanic
implements IMetaSkill {
    protected String skillName;
    protected Optional<Skill> metaskill;
    protected Map<String, String> parameters = Maps.newConcurrentMap();

    public MetaSkillMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.target_creative = true;
        this.skillName = mlc.getString(new String[]{"skill", "s", "meta", "m", "mechanics", "$", "()"});
        this.buildParameters(mlc);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading MetaSkillMechanic -> {0}", this.skillName);
            this.metaskill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded MetaSkillMechanic successfully", new Object[0]);
            }
        });
    }

    public MetaSkillMechanic(SkillExecutor manager, String skill, String skillName, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.target_creative = true;
        this.skillName = skillName;
        this.buildParameters(mlc);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading MetaSkillMechanic -> {0}", this.skillName);
            this.metaskill = MythicBukkit.inst().getSkillManager().getSkill(this.skillName);
            if (!this.metaskill.isPresent()) {
                MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded MetaSkillMechanic successfully", new Object[0]);
            }
        });
    }

    public Skill getSkill() {
        return this.metaskill.get();
    }

    @Override
    public SkillResult cast(SkillMetadata dataIn) {
        SkillMetadata data;
        if (!this.metaskill.isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaSkill {0} was not found on load", this.skillName);
            return SkillResult.INVALID_CONFIG;
        }
        Skill ms = this.metaskill.get();
        if (!ms.isUsable(dataIn)) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MetaSkill {0} is currently unusable", this.skillName);
            return SkillResult.CONDITION_FAILED;
        }
        if (!this.parameters.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Injecting {0} parameters", this.parameters.size());
            data = this.injectParameters(dataIn);
        } else {
            data = dataIn;
        }
        if (ConfigExecutor.debugLevel > 0) {
            if (data.getEntityTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (et: {0}) -> {1}", data.getEntityTargets().size(), this.skillName);
            } else if (data.getLocationTargets() != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (lt: {0}) -> {1}", data.getLocationTargets().size(), this.skillName);
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing MetaSkill (t: 0) -> {0}", this.skillName);
            }
        }
        if (this.forceSync && data.getIsAsync()) {
            data.setIsAsync(false);
            Schedulers.sync().run(() -> {
                data.setIsAsync(false);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Sync from MetaSkillMechanic", this.skillName);
                ms.execute(data);
            });
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Skill {0} Async from MetaSkillMechanic", this.skillName);
            ms.execute(data);
        }
        return SkillResult.SUCCESS;
    }

    private void buildParameters(MythicLineConfig mlc) {
        if (!MythicBukkit.isVolatile()) {
            return;
        }
        block31: for (Map.Entry<String, String> entry : mlc.entrySet()) {
            switch (entry.getKey().toLowerCase()) {
                case "skill": 
                case "s": 
                case "meta": 
                case "m": 
                case "mechanics": 
                case "cooldown": 
                case "cd": 
                case "delay": 
                case "repeat": 
                case "targetinterval": 
                case "targeti": 
                case "repeatinterval": 
                case "repeati": 
                case "power": 
                case "powersplitbetweentargets": 
                case "powersplit": 
                case "splitpower": 
                case "forcesync": 
                case "sync": 
                case "targetisorigin": 
                case "sourceisorigin": 
                case "castfromorigin": 
                case "fromorigin": 
                case "fo": 
                case "origin": 
                case "targetcreative": {
                    continue block31;
                }
            }
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    private SkillMetadata injectParameters(SkillMetadata data) {
        data = data.deepClone();
        data.getParameters().putAll(this.parameters);
        return data;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

