/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="look", description="Forces the caster to look at the target location")
public class LookMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected boolean headOnly;
    protected boolean immediately;
    protected boolean force;
    protected boolean forcePaper;

    public LookMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.headOnly = mlc.getBoolean(new String[]{"headonly", "ho"}, false);
        this.immediately = mlc.getBoolean(new String[]{"immediately", "immediate", "i"}, true);
        this.force = mlc.getBoolean(new String[]{"force", "f"}, false);
        this.forcePaper = mlc.getBoolean(new String[]{"forcepaper", "fp"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster().getEntity().getBukkitEntity() instanceof ArmorStand) {
            this.point(target.getLocation(), (ArmorStand)data.getCaster().getEntity().getBukkitEntity());
        } else if (this.force) {
            this.forceLook(data, target.getLocation());
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().lookAtEntity(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (data.getCaster().getEntity().getBukkitEntity() instanceof ArmorStand) {
            this.point(target, (ArmorStand)data.getCaster().getEntity().getBukkitEntity());
        } else if (this.force) {
            this.forceLook(data, target);
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().lookAtLocation(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        }
        return SkillResult.SUCCESS;
    }

    public void forceLook(SkillMetadata data, AbstractLocation target) {
        AbstractLocation fromLocation = data.getCaster().getLocation();
        double xDiff = target.getX() - fromLocation.getX();
        double yDiff = target.getY() - fromLocation.getY();
        double zDiff = target.getZ() - fromLocation.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yawRads = Math.acos(xDiff / distanceXZ);
        double pitchRads = Math.acos(yDiff / distanceY);
        double yaw = Math.toDegrees(yawRads);
        double pitch = Math.toDegrees(pitchRads) - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        yaw -= 90.0;
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (entity instanceof ArmorStand) {
            ArmorStand as = (ArmorStand)entity;
            this.point(target, as);
        } else {
            fromLocation.setYaw((float)yaw);
            fromLocation.setPitch((float)pitch);
            if (this.forcePaper && ServerVersion.isPaper()) {
                Mob paperMob = (Mob)entity;
                paperMob.lookAt(BukkitAdapter.adapt(target));
            } else {
                data.getCaster().getEntity().teleport(fromLocation);
            }
        }
    }

    private void point(AbstractLocation target, ArmorStand stand) {
        Location location = BukkitAdapter.adapt(target);
        Vector delta = location.toVector().subtract(stand.getLocation().toVector());
        double yaw = Math.atan2(delta.getX(), delta.getZ());
        double len = delta.getZ() / Math.cos(yaw);
        double pitch = Math.atan2(delta.getY() - 1.4375, len);
        stand.setHeadPose(new EulerAngle(-pitch, 0.0, 0.0));
        Location loc = stand.getLocation();
        loc.setYaw((float)Math.toDegrees(-yaw));
        stand.teleport(loc);
    }
}

