/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="effect:itemspray", aliases={"itemspray", "e:itemspray"}, description="Sprays items everywhere")
public class ItemSprayEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private DropTable dropTable;
    protected PlaceholderInt amount;
    protected PlaceholderInt duration;
    protected PlaceholderDouble radius;
    protected PlaceholderDouble force;
    protected PlaceholderDouble yForce;
    protected PlaceholderDouble yOffset;
    protected boolean allowPickup;
    protected boolean applyGravity;

    public ItemSprayEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 10, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 20, new String[0]);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, 0.0, new String[0]);
        this.force = mlc.getPlaceholderDouble(new String[]{"force", "f", "velocity", "v"}, 1.0, new String[0]);
        this.yForce = mlc.getPlaceholderDouble(new String[]{"yforce", "yf", "yvelocity", "yv"}, this.force, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "yo", "y"}, 1.0, new String[0]);
        this.allowPickup = mlc.getBoolean(new String[]{"allowpickup", "ap"}, false);
        this.applyGravity = mlc.getBoolean(new String[]{"gravity", "g"}, true);
        String itemString = mlc.getString(new String[]{"items", "item", "i"}, "iron_sword", new String[0]);
        Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            this.dropTable = maybeTable.get();
            return;
        }
        if (itemString.startsWith("\"")) {
            try {
                itemString = itemString.substring(1, itemString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            itemString = SkillString.parseMessageSpecialChars(itemString);
        }
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(itemString.split(",")));
        this.dropTable = new DropTable("DropItemMechanic", "DropItemMechanic", items);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target.getLocation());
        return SkillResult.SUCCESS;
    }

    protected void playEffect(SkillMetadata data, AbstractLocation l) {
        AbstractEntity caster = data.getCaster().getEntity();
        LootBag loot = this.dropTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        List<Drop> drops = loot.getLootTable();
        if (drops.size() > 1) {
            Collections.shuffle(drops);
        }
        for (Drop type : drops) {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (!(drop instanceof IItemDrop)) continue;
            ItemStack item = ((BukkitItemStack)((IItemDrop)drop).getDrop(new DropMetadataImpl(data.getCaster(), caster), amount)).build();
            SkillAdapter.get().itemSprayEffect(l, item, this.amount.get(data), this.duration.get(data), this.force.get(data), this.yForce.get(data), this.radius.get(data), this.yOffset.get(data), this.allowPickup, this.applyGravity);
        }
    }
}

