/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.inventivetalent.glow.GlowAPI;

@MythicMechanic(author="Ashijin", name="effect:glow", aliases={"glow", "e:glow"}, description="Makes the taget entity glow. Requires GlowAPI")
public class GlowEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    protected GlowAPI.Color color;
    protected int duration;

    public GlowEffect(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String color = mlc.getString(new String[]{"color", "c"}, "WHITE", new String[0]);
        try {
            this.color = GlowAPI.Color.valueOf((String)color);
        }
        catch (Error | Exception exception) {
            MythicLogger.errorMechanicConfig(this, mlc, "The GLOW Effect requires GlowAPI and the 'color' attribute must be a valid GlowAPI Color.");
        }
        this.duration = mlc.getInteger("duration", 100);
        this.duration = mlc.getInteger("d", this.duration);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target);
        return SkillResult.SUCCESS;
    }

    private class Animator {
        public Animator(AbstractEntity entity) {
            Schedulers.sync().run(() -> GlowAPI.setGlowing((Entity)BukkitAdapter.adapt(entity), (GlowAPI.Color)GlowEffect.this.color, (Collection)Bukkit.getOnlinePlayers()));
            Schedulers.sync().runLater(() -> GlowAPI.setGlowing((Entity)BukkitAdapter.adapt(entity), (boolean)false, (Collection)Bukkit.getOnlinePlayers()), GlowEffect.this.duration);
        }
    }
}

