/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="forcepull", description="Teleports the target entity to the caster")
public class ForcePullMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float spread;
    protected float spreadV;

    public ForcePullMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.spread = mlc.getFloat(new String[]{"spread", "s"}, 0.0f);
        this.spreadV = mlc.getFloat(new String[]{"vspread", "vs"}, this.spread);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.spread > 0.0f) {
            AbstractLocation location = this.sourceIsOrigin ? data.getCaster().getLocation() : data.getOrigin();
            location = MobExecutor.findSafeSpawnLocation(location, (int)this.spread, (int)this.spreadV, 1);
            target.teleport(location);
        } else {
            target.teleport(this.sourceIsOrigin ? data.getOrigin() : data.getCaster().getLocation());
        }
        return SkillResult.SUCCESS;
    }
}

