/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="fly", description="Aura that enables flying on the target entity")
public class FlyMechanic
extends Aura
implements ITargetedEntitySkill {
    public FlyMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            new FlyMechanicTracker(target, data);
        }
        return SkillResult.SUCCESS;
    }

    public class FlyMechanicTracker
    extends Aura.AuraTracker {
        private boolean couldFly;

        public FlyMechanicTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)FlyMechanic.this, target, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(FlyMechanic.this.onStartSkill, this.skillMetadata);
            this.couldFly = this.skillMetadata.getCaster().getEntity().asPlayer().getAllowFlight();
            this.skillMetadata.getCaster().getEntity().asPlayer().setAllowFlight(true);
            this.skillMetadata.getCaster().getEntity().asPlayer().setFlying(true);
        }

        @Override
        public void auraStop() {
            this.skillMetadata.getCaster().getEntity().asPlayer().setFlying(false);
            this.skillMetadata.getCaster().getEntity().asPlayer().setAllowFlight(this.couldFly);
            this.executeAuraSkill(FlyMechanic.this.onEndSkill, this.skillMetadata);
        }
    }
}

