/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="fillChest", aliases={"populateChest"}, description="Fills a chest with loot")
public class FillChestMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private DropTable dropTable;
    private String itemString;

    public FillChestMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.itemString = mlc.getString(new String[]{"items", "item", "i"});
        ((MythicBukkit)this.getPlugin()).getDropManager().queueSecondPass(() -> {
            Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(this.itemString);
            if (maybeTable.isPresent()) {
                this.dropTable = maybeTable.get();
                return;
            }
            if (this.itemString.startsWith("\"")) {
                try {
                    this.itemString = this.itemString.substring(1, this.itemString.length() - 1);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
                }
                this.itemString = SkillString.parseMessageSpecialChars(this.itemString);
            }
            ArrayList<String> items = new ArrayList<String>(Arrays.asList(this.itemString.split(",")));
            this.dropTable = new DropTable("FillChestMechanic", "FillChestMechanic", items);
        });
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        LootBag loot = this.dropTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        Location location = BukkitAdapter.adapt(target);
        if (!(location.getBlock().getState() instanceof Chest)) {
            MythicLogger.error("Location " + location.toString() + " was not a chest");
            return SkillResult.INVALID_TARGET;
        }
        Chest chest = (Chest)location.getBlock().getState();
        ArrayList<ItemStack> items = Lists.newArrayList();
        for (Drop type : loot.getLootTable()) {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (!(drop instanceof IItemDrop)) continue;
            ItemStack stack = ((BukkitItemStack)((IItemDrop)drop).getDrop(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()), amount)).build();
            items.add(stack);
        }
        for (ItemStack itemStack : items) {
            int slot = -1;
            do {
                slot = (int)(Math.random() * (double)chest.getInventory().getSize());
            } while (chest.getInventory().getItem(slot) != null);
            int fslot = slot;
            Schedulers.sync().run(() -> chest.getInventory().setItem(fslot, itemStack));
        }
        return SkillResult.SUCCESS;
    }
}

