/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="equip", description="Causes the caster to equip an item or droptable")
public class EquipMechanic
extends SkillMechanic
implements INoTargetSkill {
    private PlaceholderString equipString;
    private List<String> equipment = new ArrayList<String>();
    private DropTable equipmentTable;

    public EquipMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.equipString = mlc.getPlaceholderString(new String[]{"items", "item", "i", "equipment", "equip", "e"}, null, new String[0]);
        if (this.equipString.isStatic()) {
            ((MythicBukkit)this.getPlugin()).getDropManager().queueSecondPass(() -> {
                String equipString = this.equipString.get();
                Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(equipString);
                if (maybeTable.isPresent()) {
                    this.equipmentTable = maybeTable.get();
                    return;
                }
                if (equipString.startsWith("\"")) {
                    try {
                        equipString = equipString.substring(1, equipString.length() - 1);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
                    }
                    equipString = SkillString.parseMessageSpecialChars(equipString);
                }
                ArrayList<String> items = new ArrayList<String>(Arrays.asList(equipString.split(",")));
                this.equipmentTable = new DropTable("EquipMechanic", "EquipMechanic", items);
            });
        } else {
            this.equipmentTable = null;
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        this.getLoot(data).equip(data.getCaster().getEntity());
        return SkillResult.SUCCESS;
    }

    private LootBag getLoot(SkillMetadata data) {
        if (this.equipmentTable != null) {
            return this.equipmentTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        }
        String in = this.equipString.get(data);
        Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(in);
        if (maybeTable.isPresent()) {
            return maybeTable.get().generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        }
        ArrayList<String> items = Lists.newArrayList(in.split(","));
        return new DropTable("EquipMechanic", "EquipMechanic", items).generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
    }
}

