/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.Location;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

@MythicMechanic(author="Ashijin", name="effect:enderbeam", aliases={"enderbeam"}, description="Creates an endercrystal beam pointing at the target")
public class EnderBeamMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int duration;
    protected float yOffset;

    public EnderBeamMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 60);
        this.yOffset = mlc.getFloat(new String[]{"yoffset", "yo", "y"}, 0.0f);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(BukkitAdapter.adapt(data.getCaster().getEntity()), BukkitAdapter.adapt(target), this.duration);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(BukkitAdapter.adapt(data.getCaster().getEntity()), BukkitAdapter.adapt(target), this.duration);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable {
        private EnderCrystal crystal;
        private Location locationSource;
        private Entity entitySource;
        private Entity entity;
        private Location location;
        private int interval = 1;
        private int duration;
        private int iteration;
        private Task taskId;

        public Animator(Entity source, Location location, int duration) {
            this.entitySource = source;
            this.location = location;
            this.start(duration);
        }

        public Animator(Entity source, Entity entity, int duration) {
            this.entitySource = source;
            this.entity = entity;
            this.start(duration);
        }

        public Animator(Location source, Location location, int duration) {
            this.locationSource = source;
            this.location = location;
            this.start(duration);
        }

        public Animator(Location source, Entity entity, int duration) {
            this.locationSource = source;
            this.entity = entity;
            this.start(duration);
        }

        protected void start(int duration) {
            this.crystal = (EnderCrystal)this.entitySource.getWorld().spawnEntity(this.entitySource.getLocation().add(0.0, (double)EnderBeamMechanic.this.yOffset, 0.0), EntityType.ENDER_CRYSTAL);
            this.crystal.setShowingBottom(false);
            this.crystal.setInvulnerable(true);
            this.duration = duration;
            this.iteration = 0;
            this.taskId = Schedulers.sync().runRepeating(this, 0L, (long)this.interval);
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                this.crystal.remove();
                this.taskId.terminate();
            } else {
                Location source = this.locationSource != null ? this.locationSource : this.entitySource.getLocation();
                source = source.add(0.0, (double)EnderBeamMechanic.this.yOffset, 0.0);
                Location target = this.location != null ? this.location : this.entity.getLocation();
                this.crystal.teleport(source);
                this.crystal.setBeamTarget(target);
                ++this.iteration;
            }
        }
    }
}

