/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="doppleganger", aliases={"copyplayer"}, description="Disguises the caster as the target entity")
public class DopplegangerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean hasNameplate;
    private boolean usePlayerName;

    public DopplegangerMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.hasNameplate = mlc.getBoolean(new String[]{"hasnameplate", "nameplate"}, true);
        this.usePlayerName = mlc.getBoolean(new String[]{"useplayername", "upn"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return SkillResult.INVALID_TARGET;
        }
        if (CompatibilityManager.LibsDisguises == null) {
            return SkillResult.MISSING_COMPATIBILITY;
        }
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        String disguise = !this.hasNameplate ? "PLAYER " + target.asPlayer().getName() : (this.usePlayerName ? "PLAYER " + target.asPlayer().getName() : (am.getType().getDisplayName() == null ? "PLAYER " + target.asPlayer().getName() : "PLAYER " + target.asPlayer().getName()));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "[+] Running Doppleganger AbstractSkill with string: " + disguise, new Object[0]);
        CompatibilityManager.LibsDisguises.setDisguise(am, disguise);
        return SkillResult.SUCCESS;
    }
}

