/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="disengage", version="4.9", description="Causes the caster to leap backwards away from the target entity")
public class DisengageMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float velocity;
    protected float velocityY;

    public DisengageMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.velocity = Math.abs(mlc.getFloat(new String[]{"velocity", "v", "magnitude"}, 1.0f));
        this.velocityY = mlc.getFloat(new String[]{"velocityy", "yvelocity", "vy", "yv"}, 0.01337f);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        AbstractLocation cL = data.getCaster().getEntity().getLocation();
        if (cL.distance2DSquared(target) == 0.0) {
            target = target.add(cL.getDirection().normalize().multiply(2));
        }
        AbstractVector v = cL.toVector().subtract(target.toVector()).normalize();
        if ((double)this.velocityY != 0.01337) {
            v.setY(this.velocityY);
        }
        if ((v = v.multiply(this.velocity)).length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        data.getCaster().getEntity().setVelocity(v);
        return SkillResult.SUCCESS;
    }
}

