/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="damagePercent", aliases={"percentDamage"}, description="Deals a percentage of the target's health in damage")
public class DamagePercentMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble percent;
    protected boolean currentHealth;

    public DamagePercentMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.percent = PlaceholderDouble.of(mlc.getString(new String[]{"percent", "p"}, "0.1", new String[0]));
        this.currentHealth = mlc.getBoolean(new String[]{"current", "ch", "c"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        double damage = this.currentHealth ? target.getHealth() * this.percent.get(data, target) * (double)this.power : target.getMaxHealth() * this.percent.get(data, target) * (double)this.power;
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ DamagePercentMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
        this.doDamage(data.getCaster(), target, damage);
        return SkillResult.SUCCESS;
    }
}

