/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="removeHeldItem", aliases={"consumeHeldItem", "takeHeldItem"}, description="Removes an amount of the target's held item")
public class ConsumeHeldItemMechanic
extends SkillMechanic
implements INoTargetSkill {
    private int amount;

    public ConsumeHeldItemMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 1);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        if (data.getVariables().has("equip-item")) {
            Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
            ItemStack item = (ItemStack)data.getVariables().get("equip-item").get();
            if (item != null) {
                int newAmount = item.getAmount() - this.amount;
                if (newAmount <= 0) {
                    ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(item);
                    if (MythicBukkit.inst().getCompatibility().getArtifacts().isPresent()) {
                        MythicBukkit.inst().getCompatibility().getArtifacts().get().reparseWeapon(data.getCaster().getEntity().asPlayer());
                    }
                } else {
                    item.setAmount(newAmount);
                }
                player.updateInventory();
            }
            return SkillResult.SUCCESS;
        }
        Player player = (Player)data.getCaster().getEntity().getBukkitEntity();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null) {
            int newAmount = item.getAmount() - this.amount;
            if (newAmount <= 0) {
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(item);
                player.updateInventory();
                if (MythicBukkit.inst().getCompatibility().getArtifacts().isPresent()) {
                    MythicBukkit.inst().getCompatibility().getArtifacts().get().reparseWeapon(data.getCaster().getEntity().asPlayer());
                }
            } else {
                item.setAmount(newAmount);
            }
        }
        return SkillResult.SUCCESS;
    }
}

