/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="blockMask", aliases={"effect:blockMask", "e:blockMask"}, description="Temporarily masks a block as a different block")
public class BlockMaskEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private BlockData blockData;
    private PlaceholderInt radius;
    private PlaceholderInt radiusY;
    private PlaceholderInt duration;
    private PlaceholderDouble randomness;
    private boolean sphere;
    private MaskType maskType;

    public BlockMaskEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "gravel", new String[0]).toLowerCase();
        try {
            this.blockData = Bukkit.createBlockData((String)strMaterial);
        }
        catch (IllegalArgumentException ex) {
            this.blockData = Material.GRAVEL.createBlockData();
        }
        this.radius = mlc.getPlaceholderInteger(new String[]{"radius", "r"}, 0, new String[0]);
        this.radiusY = mlc.getPlaceholderInteger(new String[]{"radiusy", "ry"}, this.radius, new String[0]);
        this.randomness = mlc.getPlaceholderDouble(new String[]{"noise", "n"}, 0.0, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 0, new String[0]);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target.getLocation());
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, target);
        return SkillResult.SUCCESS;
    }

    public void playEffect(SkillMetadata data, AbstractLocation location) {
        int duration = this.duration.get(data);
        int radius = this.radius.get(data);
        int radiusY = this.radiusY.get(data);
        Location l = BukkitAdapter.adapt(location);
        if (radius == 0) {
            for (Player p : l.getWorld().getPlayers()) {
                if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                p.sendBlockChange(l, this.blockData);
            }
        } else {
            for (Location ll : this.getBlocksInRadius(l, true, radius, radiusY, this.randomness.get(data))) {
                for (Player p : l.getWorld().getPlayers()) {
                    if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                    p.sendBlockChange(ll, this.blockData);
                }
            }
        }
        if (duration > 0) {
            Schedulers.sync().runLater(() -> {
                Location lll = BukkitAdapter.adapt(location);
                if (radius == 0) {
                    for (Player p : lll.getWorld().getPlayers()) {
                        if (!(p.getLocation().distanceSquared(lll) < 65536.0)) continue;
                        p.sendBlockChange(lll, lll.getBlock().getBlockData());
                    }
                } else {
                    for (Location ll : this.getBlocksInRadius(lll, false, radius, radiusY, this.randomness.get(data))) {
                        for (Player p : lll.getWorld().getPlayers()) {
                            if (!(p.getLocation().distanceSquared(l) < 65536.0)) continue;
                            p.sendBlockChange(ll, ll.getBlock().getBlockData());
                        }
                    }
                }
            }, duration);
        }
    }

    private List<Location> getBlocksInRadius(Location l, boolean randomize, int radius, int radiusY, double randomness) {
        double radiusSq = Math.pow(radius, 2.0);
        ArrayList<Location> blocks = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > radiusSq || randomize && randomness > 0.0 && randomness < Numbers.randomDouble()) continue;
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && newloc.getBlock().getType().isOccluding()) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || newloc.getBlock().getType().isOccluding()) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

