/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="barCreate", aliases={"barAdd", "createBar"}, version="4.8", description="Creates a custom bossbar display")
public class BarCreateMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected String barName;
    protected PlaceholderString barDisplay;
    protected AbstractBossBar.BarColor barTimerColor;
    protected AbstractBossBar.BarStyle barTimerStyle;
    protected PlaceholderDouble value;

    public BarCreateMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.barName = mlc.getString(new String[]{"name", "n"}, "infobar", new String[0]);
        this.barDisplay = mlc.getPlaceholderString(new String[]{"display", "d", "bartimerdisplay", "bartimertext"}, "<skill.var.aura-name>", new String[0]);
        this.value = mlc.getPlaceholderDouble(new String[]{"value", "v"}, 1.0, new String[0]);
        String barTimerColor = mlc.getString(new String[]{"color", "c", "bartimercolor"}, "RED", new String[0]);
        String barTimerStyle = mlc.getString(new String[]{"style", "s", "bartimerstyle"}, "SOLID", new String[0]);
        try {
            this.barTimerColor = AbstractBossBar.BarColor.valueOf(barTimerColor);
        }
        catch (Exception ex) {
            this.barTimerColor = AbstractBossBar.BarColor.RED;
        }
        try {
            this.barTimerStyle = AbstractBossBar.BarStyle.valueOf(barTimerStyle);
        }
        catch (Exception ex) {
            this.barTimerStyle = AbstractBossBar.BarStyle.SOLID;
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return SkillResult.INVALID_TARGET;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        AbstractBossBar bar = ((MythicBukkit)this.getPlugin()).getBootstrap().createBossBar(this.barDisplay.get(data), this.barTimerColor, this.barTimerStyle);
        bar.setProgress(this.value.get(data));
        am.addBar(this.barName, bar);
        return SkillResult.SUCCESS;
    }
}

