/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.variables.VariableCondition;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="variableEquals", aliases={"variableeq", "varequals", "vareq"}, version="4.6", description="Checks if the given variable has a particular value.")
public class VariableEqualsCondition
extends VariableCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition {
    @MythicField(name="value", aliases={"val", "v"}, description="The value to match")
    private PlaceholderString value;

    public VariableEqualsCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        try {
            this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "val", "v"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        String compare = this.value.get(target);
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigExecutor.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        String compare = this.value.get();
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigExecutor.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(SkillMetadata meta) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, meta.getCaster().getEntity());
        String compare = this.value.get(meta, meta.getCaster().getEntity());
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigExecutor.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

