/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Phil", name="itemissimilar", aliases={"issimilar", "similarto"}, description="Checks if the ItemStack is similar")
public class ItemIsSimilarCondition
extends SkillCondition
implements IEntityCondition {
    private String slot;
    private BukkitItemStack item;

    public ItemIsSimilarCondition(String line, MythicLineConfig config) {
        super(line);
        this.slot = config.getString(new String[]{"slot", "s"}, "HAND", new String[0]);
        String materialString = config.getString(new String[]{"item", "i", "material", "m", "mm", "mythicitem"}, "DIRT", new String[0]);
        try {
            this.item = new BukkitItemStack(materialString);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorConditionConfig(this, config, "'" + materialString + "' is not a valid material.");
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        ItemStack item;
        if (!target.isPlayer()) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target is not a player, returning false", new Object[0]);
            return false;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        try {
            int slot = Integer.parseInt(this.slot);
            item = slot < 36 ? player.getInventory().getItem(slot) : player.getInventory().getItem(0);
        }
        catch (NumberFormatException ex) {
            switch (EquipSlot.of(this.slot)) {
                case OFFHAND: {
                    item = player.getInventory().getItemInOffHand();
                    break;
                }
                case HEAD: {
                    item = player.getInventory().getHelmet();
                    break;
                }
                case FEET: {
                    item = player.getInventory().getBoots();
                    break;
                }
                case LEGS: {
                    item = player.getInventory().getLeggings();
                    break;
                }
                case CHEST: {
                    item = player.getInventory().getChestplate();
                    break;
                }
                default: {
                    item = player.getInventory().getItemInMainHand();
                }
            }
        }
        if (item == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Item is null, returning false", new Object[0]);
            return false;
        }
        return this.item.isSimilar(item);
    }
}

