/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

@MythicCondition(author="Ashijin", name="inblock", aliases={"insideblock"}, description="Checks the material at the target location")
public class InBlockCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="block", aliases={"blocks", "b"}, description="A list of blocks to match")
    private Set<Material> blocks = new HashSet<Material>();

    public InBlockCondition(String line, MythicLineConfig config) {
        super(line);
        String[] split;
        for (String block : split = config.getString(new String[]{"blocks", "block", "b", "material", "mat", "m"}, this.conditionVar, new String[0]).split(",")) {
            try {
                Material m4 = Material.valueOf((String)block.toUpperCase());
                this.blocks.add(m4);
            }
            catch (IllegalArgumentException ex) {
                MythicLogger.errorConditionConfig(this, config, "'" + block + "' is not a valid material.");
            }
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking INBLOCK condition...", new Object[0]);
        Material mat = BukkitAdapter.adapt(l).getBlock().getType();
        if (this.blocks.contains(mat)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Material check passed for {0}", mat.toString());
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Material check failed for {0}", mat.toString());
        return false;
    }
}

