/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.numbers.RangedInt;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Phil", name="HasItem", aliases={}, description="Checks the inventory for this item")
public class HasItemCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition {
    @MythicField(name="item", aliases={"i, material, m"}, description="The item to check for")
    private BukkitItemStack item;
    @MythicField(name="amount", aliases={"a"}, description="The amount to check for")
    private RangedInt amount;

    public HasItemCondition(String line, MythicLineConfig config) {
        super(line);
        String i = config.getString(new String[]{"item", "i", "material", "m"}, "DIRT", this.conditionVar);
        this.amount = new RangedInt(config.getString(new String[]{"amount", "a"}, ">0", new String[0]));
        try {
            this.item = new BukkitItemStack(i);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorConditionConfig(this, config, "'" + i + "' is not a valid material.");
        }
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        int count = 0;
        if (!e.isPlayer()) {
            return false;
        }
        Player player = (Player)BukkitAdapter.adapt(e);
        for (ItemStack x : player.getInventory().getContents()) {
            if (x == null || !this.item.isSimilar(x)) continue;
            count += x.getAmount();
        }
        return this.amount.equals(count);
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        int count = 0;
        Location location = BukkitAdapter.adapt(l);
        if (!(location.getBlock().getState() instanceof Chest) && !(location.getBlock().getState() instanceof ShulkerBox)) {
            return false;
        }
        if (location.getBlock().getState() instanceof Chest) {
            Chest chest = (Chest)location.getBlock().getState();
            for (ItemStack x : chest.getBlockInventory().getContents()) {
                if (x == null || !this.item.isSimilar(x)) continue;
                count += x.getAmount();
            }
            return this.amount.equals(count);
        }
        if (location.getBlock().getState() instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)location.getBlock().getState();
            for (ItemStack x : shulker.getInventory().getContents()) {
                if (x == null || !this.item.isSimilar(x)) continue;
                count += x.getAmount();
            }
            return this.amount.equals(count);
        }
        return false;
    }
}

