/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;

@MythicCondition(author="Ashijin", name="blockType", aliases={}, description="Tests the material type present at the target location")
public class BlockTypeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="types", aliases={"type", "t"}, description="A list of materials to check")
    private Collection<BlockType> types = Sets.newHashSet();

    public BlockTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String b = mlc.getString(new String[]{"types", "type", "t", "material", "mat", "m"}, "DIRT", this.conditionVar);
        for (String s2 : b.split(",")) {
            if (!s2.toUpperCase().startsWith("MMOITEMS")) {
                for (Material mats : Material.values()) {
                    if (!mats.toString().matches(Patterns.toRegex(s2.toUpperCase()))) continue;
                    this.types.add(new BlockType(mats));
                }
                continue;
            }
            try {
                this.types.add(new BlockType(s2.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {
                MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid material.");
            }
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        for (BlockType type : this.types) {
            if (!type.check(BukkitAdapter.adapt(l).getBlock())) continue;
            return true;
        }
        return false;
    }

    private class BlockType {
        private final Material material;
        private int mmoId = -1;

        public BlockType(String type) {
            type = type.toUpperCase();
            if (type.startsWith("MMOITEMS")) {
                type = type.substring(9);
                int id = Integer.valueOf(type);
                this.material = SkillCondition.getPlugin().getCompatibility().getMMOItems().get().getCustomBlockMaterial(id);
                this.mmoId = id;
            } else {
                this.material = Material.valueOf((String)type);
            }
        }

        public BlockType(Material material) {
            this.material = material;
        }

        public boolean check(Block block) {
            if (block.getType() != this.material) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Material check failed {0} != {1}", this.material, block.getType());
                return false;
            }
            if (this.mmoId >= 0 && !SkillCondition.getPlugin().getCompatibility().getMMOItems().get().checkCustomBlock(block, this.mmoId)) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "MMOItems block id check failed {0}", this.mmoId);
                return false;
            }
            return true;
        }
    }
}

