/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.entity.Entity;

@MythicCondition(author="Ashijin", name="altitude", aliases={"heightfromsurface"}, description="Tests how far above the ground the target entity is")
public class AltitudeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="height", aliases={"altitude", "a", "h"}, description="The height range to check")
    private RangedDouble height;

    public AltitudeCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.height = new RangedDouble(mlc.getString(new String[]{"height", "h", "altitude", "a"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity target) {
        Entity e = target.getBukkitEntity();
        int ydiff = e.getLocation().getBlockY() - e.getWorld().getHighestBlockYAt(e.getLocation());
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Altitude is {0}, checking against {1}", ydiff, this.height.toString());
        return this.height.equals(ydiff);
    }
}

