/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Aura
extends SkillMechanic {
    protected Optional<String> auraName = Optional.empty();
    protected PlaceholderInt charges;
    protected PlaceholderInt interval;
    protected PlaceholderInt duration;
    protected PlaceholderInt maxStacks;
    protected boolean mergeAll;
    protected boolean mergeSameCaster;
    protected boolean overwriteAll;
    protected boolean overwriteCaster;
    protected boolean refreshDuration;
    protected boolean showBarTimer;
    protected PlaceholderString barTimerDisplay = null;
    protected AbstractBossBar.BarColor barTimerColor = null;
    protected AbstractBossBar.BarStyle barTimerStyle = null;
    protected boolean cancelOnGiveDamage;
    protected boolean cancelOnTakeDamage;
    protected boolean cancelOnDeath;
    protected boolean cancelOnTeleport;
    protected boolean cancelOnChangeWorld;
    protected boolean cancelOnSkillCast;
    protected boolean cancelOnQuit;
    protected boolean doEndSkillOnTerminate;
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected String onStartSkillName;
    protected String onTickSkillName;
    protected String onEndSkillName;

    public Aura(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        String auraName = mlc.getString(new String[]{"auraname", "buffname", "debuffname"}, null, new String[0]);
        if (auraName != null) {
            this.auraName = Optional.of(auraName);
        }
        this.charges = mlc.getPlaceholderInteger(new String[]{"charges", "c"}, 0, new String[0]);
        this.interval = mlc.getPlaceholderInteger(new String[]{"interval", "i"}, 1, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d", "time", "t"}, 200, new String[0]);
        this.maxStacks = mlc.getPlaceholderInteger(new String[]{"maxstacks", "ms"}, 1, new String[0]);
        this.mergeAll = mlc.getBoolean(new String[]{"mergeall", "ma"}, false);
        this.overwriteAll = mlc.getBoolean(new String[]{"overwriteall", "overwrite", "ow"}, false);
        this.overwriteCaster = mlc.getBoolean(new String[]{"overwritesamecaster", "osc", "oc"}, false);
        this.mergeSameCaster = mlc.getBoolean(new String[]{"mergesamecaster", "msc", "mc"}, !this.mergeAll && !this.overwriteAll && !this.overwriteCaster);
        this.refreshDuration = mlc.getBoolean(new String[]{"refreshduration", "rd"}, true);
        this.showBarTimer = mlc.getBoolean(new String[]{"showbartimer", "bartimer", "bt"}, false);
        if (this.showBarTimer) {
            this.barTimerDisplay = mlc.getPlaceholderString(new String[]{"bartimerdisplay", "bartimertext"}, "<skill.var.aura-name>", new String[0]);
            String barTimerColor = mlc.getString("bartimercolor", "RED");
            String barTimerStyle = mlc.getString("bartimerstyle", "SOLID");
            try {
                this.barTimerColor = AbstractBossBar.BarColor.valueOf(barTimerColor);
            }
            catch (Exception ex) {
                this.barTimerColor = AbstractBossBar.BarColor.RED;
            }
            try {
                this.barTimerStyle = AbstractBossBar.BarStyle.valueOf(barTimerStyle);
            }
            catch (Exception ex) {
                this.barTimerStyle = AbstractBossBar.BarStyle.SOLID;
            }
        }
        this.cancelOnGiveDamage = mlc.getBoolean(new String[]{"cancelongivedamage", "cogd"}, false);
        this.cancelOnTakeDamage = mlc.getBoolean(new String[]{"cancelontakedamage", "cotd"}, false);
        this.cancelOnDeath = mlc.getBoolean(new String[]{"cancelondeath", "cod"}, true);
        this.cancelOnTeleport = mlc.getBoolean(new String[]{"cancelonteleport", "cot"}, false);
        this.cancelOnChangeWorld = mlc.getBoolean(new String[]{"cancelonchangeworld", "cocw"}, false);
        this.cancelOnSkillCast = mlc.getBoolean(new String[]{"cancelonskilluse", "cosu"}, false);
        this.cancelOnQuit = mlc.getBoolean(new String[]{"cancelonquit", "coq"}, true);
        this.doEndSkillOnTerminate = mlc.getBoolean(new String[]{"doendskillonterminate", "desot", "alwaysrunendskill", "ares"}, true);
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        MythicBukkit.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onStartSkillName != null) {
                this.onStartSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onStartSkillName);
            }
            if (this.onTickSkillName != null) {
                this.onTickSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onTickSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onEndSkillName);
            }
        });
    }

    public abstract class AuraTracker
    implements Terminable,
    Runnable,
    IParentSkill {
        protected final TerminableRegistry components = TerminableRegistry.create();
        protected SkillMetadata skillMetadata;
        protected Optional<AbstractEntity> entity;
        protected Optional<AbstractLocation> location;
        protected transient AbstractBossBar barTimer = null;
        protected int stacks = 1;
        protected int maxStacks;
        protected int chargesRemaining;
        protected int ticksRemaining;
        protected int startDuration;
        protected int startCharges;
        protected int interval;
        protected boolean hasEnded = false;

        public AuraTracker(SkillMetadata data) {
            this.entity = Optional.of(data.getCaster().getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deepClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker Activated for Caster {0}: skill = {1}", data.getCaster().getEntity().getName(), Aura.this.line);
        }

        public AuraTracker(SkillCaster caster, AbstractEntity target, SkillMetadata data) {
            this.entity = Optional.of(caster.getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deepClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setEntityTarget(target);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data, target);
            this.ticksRemaining = Aura.this.duration.get(data, target);
            this.maxStacks = Aura.this.maxStacks.get(data, target);
            this.startDuration = Aura.this.duration.get(data, target);
            this.startCharges = Aura.this.charges.get(data, target);
            this.interval = Aura.this.interval.get(data, target);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker Activated for Entity {0}: skill  = {1}", caster.getEntity().getName(), Aura.this.line);
        }

        public AuraTracker(AbstractEntity entity, SkillMetadata data) {
            this.entity = Optional.of(entity);
            this.location = Optional.empty();
            this.skillMetadata = data.deepClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata = this.skillMetadata.setEntityTarget(entity);
            this.skillMetadata = this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data, entity);
            this.ticksRemaining = Aura.this.duration.get(data, entity);
            this.maxStacks = Aura.this.maxStacks.get(data, entity);
            this.startDuration = Aura.this.duration.get(data, entity);
            this.startCharges = Aura.this.charges.get(data, entity);
            this.interval = Aura.this.interval.get(data, entity);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker Activated for Entity {0}: skill = {1}", entity.getName(), Aura.this.line);
        }

        public AuraTracker(SkillCaster caster, AbstractLocation target, SkillMetadata data) {
            this.entity = Optional.of(caster.getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deepClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata = this.skillMetadata.setLocationTarget(target);
            this.skillMetadata = this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker Activated for Location {0}: skill = {1}", this.location.toString(), Aura.this.line);
        }

        public AuraTracker(AbstractLocation location, SkillMetadata data) {
            this.entity = Optional.empty();
            this.location = Optional.of(location);
            this.skillMetadata = data.deepClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setLocationTarget(location);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker Activated for Location {0}: skill = {1}", location.toString(), Aura.this.line);
        }

        public void registerAuraComponent(Terminable component) {
            this.components.accept(component);
        }

        public UUID getCasterUUID() {
            return this.skillMetadata.getCaster().getEntity().getUniqueId();
        }

        public void merge(AuraTracker tracker) {
            this.stacks += tracker.getStacks();
            if (this.stacks > this.maxStacks) {
                this.stacks = this.maxStacks;
            }
            if (Aura.this.refreshDuration) {
                this.chargesRemaining = Aura.this.charges.get(this.skillMetadata);
                this.ticksRemaining = Aura.this.duration.get(this.skillMetadata);
            }
        }

        public boolean executeAuraSkill(Optional<Skill> skill, SkillMetadata data) {
            return this.executeAuraSkill(skill, data, false);
        }

        public boolean executeAuraSkill(Optional<Skill> skill, SkillMetadata data, boolean atCaster) {
            data = data.deepClone();
            if (atCaster) {
                data = data.setEntityTarget(data.getCaster().getEntity());
            } else if (this.entity.isPresent()) {
                data.getEntityTargets().clear();
                data.setEntityTarget(this.entity.get());
            }
            VariableRegistry vars = data.getVariables();
            if (Aura.this.auraName.isPresent()) {
                vars.putString("aura-name", Aura.this.auraName.get());
            }
            vars.putInt("aura-charges", this.chargesRemaining);
            vars.putInt("aura-duration", this.ticksRemaining);
            vars.putInt("aura-stacks", this.stacks);
            if (this.barTimer != null) {
                double progress = (double)this.ticksRemaining / (double)this.startDuration;
                this.barTimer.setTitle(Aura.this.barTimerDisplay.get(data, this.entity.get()));
                this.barTimer.setProgress(progress);
            }
            if (skill == null || !skill.isPresent()) {
                return true;
            }
            if (skill.get().isUsable(data)) {
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public boolean executeTargetedAuraSkill(Optional<Skill> skill, SkillMetadata data, AbstractEntity target) {
            data = data.deepClone();
            data.getEntityTargets().clear();
            data.setEntityTarget(target);
            VariableRegistry vars = data.getVariables();
            if (Aura.this.auraName.isPresent()) {
                vars.putString("aura-name", Aura.this.auraName.get());
            }
            vars.putInt("aura-charges", this.chargesRemaining);
            vars.putInt("aura-duration", this.ticksRemaining);
            vars.putInt("aura-stacks", this.stacks);
            if (this.barTimer != null) {
                double progress = (double)this.ticksRemaining / (double)this.startDuration;
                this.barTimer.setTitle(Aura.this.barTimerDisplay.get(data, this.entity.get()));
                this.barTimer.setProgress(progress);
            }
            if (skill == null || !skill.isPresent()) {
                return true;
            }
            if (skill.get().isUsable(data)) {
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public boolean start() {
            String auraName;
            String string = auraName = Aura.this.auraName.isPresent() ? Aura.this.auraName.get() : UUID.randomUUID().toString();
            if (this.entity.isPresent()) {
                if (Aura.this.mergeAll || Aura.this.mergeSameCaster) {
                    if (((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).mergeAura(auraName, this, Aura.this.mergeSameCaster)) {
                        return false;
                    }
                } else {
                    if (Aura.this.overwriteAll || Aura.this.overwriteCaster) {
                        ((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).removeAll(auraName);
                    }
                    ((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).registerAura(auraName, this);
                }
            }
            if (this.entity.isPresent()) {
                AbstractEntity entity = this.entity.get();
                UUID uuid = entity.getUniqueId();
                if (Aura.this.cancelOnGiveDamage) {
                    this.components.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                }
                if (Aura.this.cancelOnTakeDamage) {
                    this.components.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                }
                if (Aura.this.cancelOnTeleport && entity.isPlayer()) {
                    this.components.accept(Events.subscribe(PlayerTeleportEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                    this.components.accept(Events.subscribe(PlayerPortalEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                }
                if (Aura.this.cancelOnQuit && entity.isPlayer()) {
                    this.components.accept(Events.subscribe(PlayerQuitEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                }
                if (Aura.this.cancelOnDeath) {
                    this.components.accept(Events.subscribe(EntityDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                    this.components.accept(Events.subscribe(PlayerDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()));
                }
                if (Aura.this.showBarTimer && entity.isPlayer()) {
                    this.barTimer = MythicBukkit.inst().getBootstrap().createBossBar(" ", Aura.this.barTimerColor, Aura.this.barTimerStyle);
                    this.barTimer.setProgress(1.0);
                    this.barTimer.addPlayer(entity.asPlayer());
                    this.components.accept(this.barTimer);
                }
            }
            if (Aura.this.threadSafetyLevel != ThreadSafetyLevel.SYNC_ONLY) {
                this.components.accept(Schedulers.async().runRepeating(this, 0L, (long)this.interval));
            } else {
                this.components.accept(Schedulers.sync().runRepeating(this, 0L, (long)this.interval));
            }
            this.auraStart();
            return true;
        }

        public boolean isValid() {
            if (this.components.hasTerminated() || this.hasEnded) {
                return false;
            }
            if (this.startCharges > 0 && this.chargesRemaining <= 0) {
                return false;
            }
            if (this.ticksRemaining <= 0) {
                return false;
            }
            return !this.entity.isPresent() || this.entity.get().isValid();
        }

        @Override
        public void run() {
            this.ticksRemaining -= this.interval;
            if (!this.hasEnded && !this.isValid()) {
                this.terminate();
            } else {
                if (this.entity.isPresent()) {
                    this.skillMetadata.setOrigin(this.entity.get().getLocation());
                }
                this.auraTick();
            }
        }

        public void consumeCharge() {
            if (this.startCharges <= 0) {
                return;
            }
            --this.chargesRemaining;
            if (this.chargesRemaining <= 0) {
                this.terminate();
            }
        }

        public void auraStart() {
            this.executeAuraSkill(Aura.this.onStartSkill, this.skillMetadata);
        }

        public void auraTick() {
            this.executeAuraSkill(Aura.this.onTickSkill, this.skillMetadata);
        }

        public void auraStop() {
            this.executeAuraSkill(Aura.this.onEndSkill, this.skillMetadata, false);
        }

        public void terminateFromRegistry() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker cancelled from Registry for " + this.skillMetadata.getCaster().getEntity().getName() + ": skill = " + Aura.this.line, new Object[0]);
            if (!this.hasEnded) {
                try {
                    this.auraStop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.barTimer != null) {
                    this.barTimer = null;
                }
                this.hasEnded = true;
            }
            this.components.terminate();
        }

        @Override
        public void close() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker cancelled for {0}: skill = {1}", this.skillMetadata.getCaster().getName(), Aura.this.line);
            if (!this.hasEnded) {
                try {
                    this.auraStop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.entity.isPresent() && Aura.this.auraName.isPresent()) {
                    ((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).unregisterAura(Aura.this.auraName.get(), this);
                }
                if (this.barTimer != null) {
                    this.barTimer = null;
                }
                this.hasEnded = true;
            }
            this.components.terminate();
        }

        @Override
        public void setCancelled() {
            this.close();
        }

        @Override
        public boolean getCancelled() {
            return this.hasTerminated();
        }

        public SkillMetadata getSkillMetadata() {
            return this.skillMetadata;
        }

        public int getStacks() {
            return this.stacks;
        }

        public void setStacks(int stacks) {
            this.stacks = stacks;
        }

        public int getMaxStacks() {
            return this.maxStacks;
        }

        public int getChargesRemaining() {
            return this.chargesRemaining;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public int getStartDuration() {
            return this.startDuration;
        }

        public int getStartCharges() {
            return this.startCharges;
        }

        public int getInterval() {
            return this.interval;
        }

        public boolean isHasEnded() {
            return this.hasEnded;
        }
    }
}

