/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.mechanics.CastMechanic;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.SudoSkillMechanic;
import io.lumine.mythic.core.skills.targeters.IPathSelector;
import io.lumine.mythic.core.skills.targeters.MPEntity;
import io.lumine.mythic.core.skills.targeters.MPLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Bukkit;

public class SkillMechanic
extends AbstractSkill
implements ISkillMechanic {
    protected final MythicLineConfig config;
    protected int interval = 0;
    protected long clock = 0L;
    protected String line;
    protected boolean forceSync = false;
    protected boolean executeAfterDeath = false;
    protected boolean targetIsOrigin = false;
    protected Optional<SkillTargeter> originOverride;

    public SkillMechanic(SkillExecutor manager, String line, MythicLineConfig mlc, int interval) {
        super(manager);
        this.config = mlc;
        this.interval = interval + (ConfigExecutor.ClockInterval - interval % ConfigExecutor.ClockInterval);
        this.init(line, mlc);
    }

    public SkillMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager);
        this.config = mlc;
        this.init(line, mlc);
    }

    private void init(String line, MythicLineConfig mlc) {
        String cd2 = mlc.getString(new String[]{"cooldown", "cd"}, null, new String[0]);
        if (cd2 != null) {
            this.cooldown = PlaceholderDouble.of(cd2);
        }
        this.delay = mlc.getPlaceholderInteger("delay", 0);
        this.targetInterval = mlc.getPlaceholderDouble(new String[]{"targetinterval", "targeti"}, 0.0, new String[0]);
        this.repeat = mlc.getPlaceholderInteger("repeat", 0);
        this.repeatInterval = mlc.getPlaceholderInteger(new String[]{"repeatinterval", "repeati"}, 0, new String[0]);
        this.power = mlc.getFloat("power", 1.0f);
        this.powerSplitBetweenTargets = mlc.getBoolean(new String[]{"powersplitbetweentargets", "powersplit", "splitpower"}, false);
        this.forceSync = mlc.getBoolean(new String[]{"forcesync", "sync"}, false);
        this.targetIsOrigin = mlc.getBoolean("targetisorigin", false);
        this.sourceIsOrigin = mlc.getBoolean(new String[]{"sourceisorigin", "castfromorigin", "fromorigin", "fo"}, false);
        String originOverride = mlc.getString("origin", null);
        this.originOverride = originOverride != null && MythicBukkit.isVolatile() ? Optional.of(this.parseSkillTargeter(originOverride)) : Optional.empty();
        this.target_creative = mlc.getBoolean("targetcreative", this.target_creative);
        String[] split = line.split(" ");
        for (int i = 1; i < split.length; ++i) {
            SkillCondition cond;
            if (split[i].startsWith("@")) {
                this.targeter = Optional.of(this.parseSkillTargeter(split[i]));
                continue;
            }
            if (split[i].startsWith("~")) {
                this.trigger = this.parseSkillTrigger(split[i]);
                continue;
            }
            if (split[i].startsWith("=") || split[i].startsWith(">") || split[i].startsWith("<")) {
                this.healthMod = split[i];
                continue;
            }
            if (split[i].startsWith("?~")) {
                if (this.conditionsTrigger == null) {
                    this.conditionsTrigger = new ArrayList();
                }
                cond = this.parseSkillCondition(split[i].substring(1));
                this.conditionsTrigger.add(cond);
                continue;
            }
            if (split[i].startsWith("?")) {
                if (this.conditions == null) {
                    this.conditions = new ArrayList();
                }
                cond = this.parseSkillCondition(split[i]);
                this.conditions.add(cond);
                continue;
            }
            if (!split[i].matches("[0-9]*[.]?[0-9]+")) continue;
            this.chance = Float.parseFloat(split[i]);
        }
        if (this.trigger == null) {
            this.trigger = SkillTriggers.COMBAT;
        }
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setAsyncSafe(boolean bool) {
        this.threadSafetyLevel = bool ? ThreadSafetyLevel.EITHER : ThreadSafetyLevel.SYNC_ONLY;
    }

    public boolean isAsyncSafe() {
        return this.threadSafetyLevel != ThreadSafetyLevel.SYNC_ONLY;
    }

    public void setTimerInterval(int interval) {
        this.interval = interval;
    }

    public int getTimerInterval() {
        return this.interval;
    }

    public void resetClock() {
        this.clock = 0L;
    }

    public void tickClock() {
        this.clock += (long)ConfigExecutor.ClockInterval;
    }

    public long getClock() {
        return this.clock;
    }

    public boolean isUsableFromSkill(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerConditions failed", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Conditions failed", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    public boolean isUsableFromCaster(SkillMetadata meta) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.checkSkillTrigger(meta)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: TriggerConditions failed", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Conditions failed", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillMetadata meta) {
        return this.isUsableFromCaster(meta);
    }

    @Deprecated
    public boolean usable(SkillCaster skillCaster, SkillTrigger trigger) {
        if (!this.checkSkillTrigger(trigger)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: SkillTrigger check failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    @Deprecated
    public boolean usable(SkillCaster am) {
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (am instanceof ActiveMob && !this.checkHealth(am)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! SkillMechanic not usable: Health check failed.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ SkillMechanic usable!", new Object[0]);
        return true;
    }

    public boolean execute(SkillMetadata oData) {
        final SkillMetadata data = oData.deepClone();
        if (this.originOverride.isPresent()) {
            data.setOrigin(((MythicBukkit)this.getPlugin()).getSkillManager().getLocationTarget(this.originOverride.get(), oData));
        }
        final int delay = this.delay.get(oData);
        double targetInterval = this.targetInterval.get(oData);
        final int repeat = this.repeat.get(oData);
        final int repeatInterval = this.repeatInterval.get(oData);
        if (repeat > 0 && repeatInterval > 0) {
            final SkillMechanic skill = this;
            new Runnable(){
                private int ticks = 0;
                private int repeats = repeat;
                private Task task = Schedulers.sync().runRepeating(this, (long)delay, (long)repeatInterval);

                @Override
                public void run() {
                    ++this.ticks;
                    try {
                        skill.executeSkills(data.deepClone());
                        if (this.ticks > this.repeats) {
                            this.task.terminate();
                        }
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                        this.task.terminate();
                    }
                }
            };
            return true;
        }
        if (targetInterval > 0.0) {
            SkillMechanic skill;
            SkillMetadata thisData;
            ArrayList<AbstractEntity> thisCastTargets;
            ArrayList<AbstractEntity> entityTargets = new ArrayList<AbstractEntity>(oData.getEntityTargets());
            ArrayList<AbstractLocation> locationTargets = new ArrayList<AbstractLocation>(oData.getLocationTargets());
            int intervalDelay = targetInterval < 1.0 ? 1 : (int)targetInterval;
            int amountPerTick = targetInterval >= 1.0 ? 1 : (int)(1.0 / targetInterval);
            int j = 1;
            while (entityTargets.size() > 0) {
                if (entityTargets.size() < amountPerTick) {
                    amountPerTick = entityTargets.size();
                }
                thisCastTargets = new ArrayList<AbstractEntity>();
                for (int i = 0; i < amountPerTick; ++i) {
                    thisCastTargets.add(entityTargets.get(0));
                    entityTargets.remove(0);
                }
                thisData = data.deepClone();
                thisData.setEntityTargets(thisCastTargets);
                thisData.getLocationTargets().clear();
                skill = this;
                Schedulers.sync().runLater(() -> skill.executeSkills(thisData), (long)j * (long)intervalDelay);
                ++j;
            }
            j = 1;
            while (locationTargets.size() > 0) {
                if (locationTargets.size() < amountPerTick) {
                    amountPerTick = locationTargets.size();
                }
                thisCastTargets = new ArrayList();
                for (int i = 0; i < amountPerTick; ++i) {
                    thisCastTargets.add((AbstractEntity)((Object)locationTargets.get(0)));
                    locationTargets.remove(0);
                }
                thisData = data.deepClone();
                thisData.setLocationTargets(thisCastTargets);
                thisData.getEntityTargets().clear();
                skill = this;
                Schedulers.sync().runLater(() -> skill.executeSkills(thisData), (long)j * (long)intervalDelay);
                ++j;
            }
            return true;
        }
        if (delay == 0) {
            return this.executeSkills(data);
        }
        SkillMechanic skill = this;
        Schedulers.sync().runLater(() -> skill.executeSkills(data), delay);
        return true;
    }

    public boolean executeSkills(SkillTrigger skilltrigger, ActiveMob am, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadataImpl data = new SkillMetadataImpl(skilltrigger, am, trigger, origin, eTargets, lTargets, power);
        return this.executeSkills(data);
    }

    public boolean executeSkills(SkillMetadata data) {
        ISkillMechanic mechanic;
        if (!data.getExecuteAfterDeath()) {
            ActiveMob am;
            if (this.executeAfterDeath) {
                data.setExecuteAfterDeath(true);
            } else if (data.getCaster() instanceof ActiveMob && (am = (ActiveMob)data.getCaster()).isDead()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Caster is dead, cancelling execution (line: {0})", this.line);
                return false;
            }
        }
        if (data.getOrigin() == null) {
            data.setOrigin(data.getCaster().getEntity().getLocation());
        }
        data.setPower(data.getPower() * this.power);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Executing SkillMechanic with power {0} (line: {1})", Float.valueOf(data.getPower()), this.line);
        this.evaluateTargets(data);
        if (this instanceof SudoSkillMechanic) {
            ((SudoSkillMechanic)this).cast(data);
            this.triggerCooldown(data);
            return true;
        }
        if (this instanceof CustomMechanic && ((CustomMechanic)this).getMechanic().isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a CUSTOM mechanic", new Object[0]);
            mechanic = ((CustomMechanic)this).getMechanic().get();
        } else {
            mechanic = this;
        }
        if (mechanic instanceof IMetaSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is a META mechanic. Executing...", new Object[0]);
            ((IMetaSkill)mechanic).cast(data);
            this.triggerCooldown(data);
            return true;
        }
        if (mechanic instanceof ITargetedEntitySkill && mechanic instanceof ITargetedLocationSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic accepts multiple types...", new Object[0]);
            if (this.targeter.isPresent() && this.targeter.get() instanceof IPathSelector) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Targeter is PATH SELECTOR", new Object[0]);
                if (this.targeter.get() instanceof MPEntity) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as ENTITY skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedEntitySkill(mechanic, data, this.targetIsOrigin);
                    this.triggerCooldown(data);
                    return true;
                }
                if (this.targeter.get() instanceof MPLocation) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic set as LOCATION skill. Executing...", new Object[0]);
                    SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin);
                    this.triggerCooldown(data);
                    return true;
                }
            }
        }
        if (mechanic instanceof ITargetedEntitySkill && data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic is an ENTITY skill. Executing...", new Object[0]);
            this.runMechanic(data, () -> SkillMechanic.executeTargetedEntitySkill(mechanic, data, this.targetIsOrigin));
            this.triggerCooldown(data);
            return true;
        }
        if (mechanic instanceof ITargetedLocationSkill) {
            if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin));
                this.triggerCooldown(data);
                return true;
            }
            if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Executing SkillMechanic as ENTITY_LOCATION skill", new Object[0]);
                this.runMechanic(data, () -> SkillMechanic.executeTargetedLocationSkill(mechanic, data, this.targetIsOrigin));
                this.triggerCooldown(data);
                return true;
            }
        }
        if (mechanic instanceof INoTargetSkill) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillMechanic runnable with no targets. Executing...", new Object[0]);
            this.runMechanic(data, () -> SkillMechanic.executeNoTargetSkill(mechanic, data));
            this.triggerCooldown(data);
            return true;
        }
        if (mechanic instanceof CastMechanic) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "- SkillMechanic is a CAST mechanic. Executing NoTargets fallback.", new Object[0]);
            ((CastMechanic)mechanic).failNoTargets(data);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "! No targets available. Cancelling.", new Object[0]);
        return false;
    }

    private void runMechanic(SkillMetadata data, Runnable run) {
        if ((data.getIsAsync() || !Bukkit.isPrimaryThread()) && this.threadSafetyLevel == ThreadSafetyLevel.SYNC_ONLY) {
            Schedulers.sync().run(run);
        } else if ((!data.getIsAsync() || Bukkit.isPrimaryThread()) && this.threadSafetyLevel == ThreadSafetyLevel.ASYNC_ONLY) {
            Schedulers.async().run(run);
        } else {
            run.run();
        }
    }

    protected static void executeTargetedEntitySkill(ISkillMechanic mechanic, SkillMetadata data, boolean targetIsOrigin) {
        data.getEntityTargets().forEach(target -> {
            if (targetIsOrigin) {
                ((ITargetedEntitySkill)mechanic).castAtEntity(data.deepClone().setOrigin(target.getLocation()), (AbstractEntity)target);
            } else {
                ((ITargetedEntitySkill)mechanic).castAtEntity(data, (AbstractEntity)target);
            }
        });
    }

    protected static void executeTargetedLocationSkill(ISkillMechanic mechanic, SkillMetadata data, boolean targetIsOrigin) {
        if (data.getLocationTargets() != null) {
            data.getLocationTargets().forEach(target -> {
                if (targetIsOrigin) {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data.deepClone().setOrigin((AbstractLocation)target), (AbstractLocation)target);
                } else {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data, (AbstractLocation)target);
                }
            });
        } else if (data.getEntityTargets() != null) {
            data.getEntityTargets().forEach(entity -> {
                AbstractLocation target = entity.getLocation();
                if (targetIsOrigin) {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data.deepClone().setOrigin(target), target);
                } else {
                    ((ITargetedLocationSkill)mechanic).castAtLocation(data, target);
                }
            });
        }
    }

    protected static void executeNoTargetSkill(ISkillMechanic mechanic, SkillMetadata data) {
        ((INoTargetSkill)mechanic).cast(data);
    }

    public boolean getRunAsync() {
        return !this.forceSync;
    }
}

