/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillManager;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.audience.CustomAudience;
import io.lumine.mythic.core.skills.audience.TargeterAudience;
import io.lumine.mythic.core.skills.auras.AuraManager;
import io.lumine.mythic.core.skills.conditions.CustomCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.MetaSkillMechanic;
import io.lumine.mythic.core.skills.mechanics.ModifyScoreMechanic;
import io.lumine.mythic.core.skills.mechanics.SendResourcePackMechanic;
import io.lumine.mythic.core.skills.mechanics.SendTitleMechanic;
import io.lumine.mythic.core.skills.mechanics.SetBlockTypeMechanic;
import io.lumine.mythic.core.skills.mechanics.SetGlidingMechanic;
import io.lumine.mythic.core.skills.mechanics.SetGlobalScoreMechanic;
import io.lumine.mythic.core.skills.mechanics.SetHealthMechanic;
import io.lumine.mythic.core.skills.mechanics.SetMaxHealthMechanic;
import io.lumine.mythic.core.skills.mechanics.SetMobScoreMechanic;
import io.lumine.mythic.core.skills.mechanics.SetOwnerMechanic;
import io.lumine.mythic.core.skills.mechanics.SetStanceMechanic;
import io.lumine.mythic.core.skills.mechanics.SetTargetScoreMechanic;
import io.lumine.mythic.core.skills.mechanics.SetUseGravityMechanic;
import io.lumine.mythic.core.skills.mechanics.ShieldMechanic;
import io.lumine.mythic.core.skills.mechanics.ShieldPercentMechanic;
import io.lumine.mythic.core.skills.mechanics.ShootFireballMechanic;
import io.lumine.mythic.core.skills.mechanics.ShootSkullMechanic;
import io.lumine.mythic.core.skills.mechanics.SignalMechanic;
import io.lumine.mythic.core.skills.mechanics.SpringMechanic;
import io.lumine.mythic.core.skills.mechanics.SummonMechanic;
import io.lumine.mythic.core.skills.mechanics.SummonPassengerMechanic;
import io.lumine.mythic.core.skills.mechanics.VariableAddMechanic;
import io.lumine.mythic.core.skills.mechanics.VariableSetMechanic;
import io.lumine.mythic.core.skills.mechanics.VariableSubtractMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.CustomTargeter;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.LivingInWorldTargeter;
import io.lumine.mythic.core.skills.targeters.LivingNearTargetLocationTargeter;
import io.lumine.mythic.core.skills.targeters.LocationTargeter;
import io.lumine.mythic.core.skills.targeters.MPEntity;
import io.lumine.mythic.core.skills.targeters.MPLocation;
import io.lumine.mythic.core.skills.targeters.MPMeta;
import io.lumine.mythic.core.skills.targeters.MobsInRadiusTargeter;
import io.lumine.mythic.core.skills.targeters.MobsNearOriginTargeter;
import io.lumine.mythic.core.skills.targeters.NearestPlayerTargeter;
import io.lumine.mythic.core.skills.targeters.PassengerTargeter;
import io.lumine.mythic.core.skills.targeters.PlayerLocationsInRadiusTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersInRingTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersInWorldTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersNearOriginTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersNearTargetLocationsTargeter;
import io.lumine.mythic.core.skills.targeters.PlayersOnServerTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTablePlayersTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTableRandomTargeter;
import io.lumine.mythic.core.skills.targeters.ThreatTableTargeter;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import io.lumine.mythic.core.skills.targeters.VanillaTargeter;
import io.lumine.mythic.core.utils.annotations.MythicAudience;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import io.lumine.mythic.core.utils.reflections.VersionCompliantReflections;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SkillExecutor
extends ReloadableModule<MythicBukkit>
implements SkillManager {
    private static final Map<String, Class<? extends SkillCondition>> CONDITIONS = new ConcurrentHashMap<String, Class<? extends SkillCondition>>();
    private static final Map<String, Class<? extends SkillMechanic>> MECHANICS = new ConcurrentHashMap<String, Class<? extends SkillMechanic>>();
    private static final Map<String, Class<? extends SkillTargeter>> TARGETERS = new ConcurrentHashMap<String, Class<? extends SkillTargeter>>();
    private static final Map<String, Class<? extends SkillAudience>> AUDIENCES = new ConcurrentHashMap<String, Class<? extends SkillAudience>>();
    private List<File> skillFiles;
    private IOLoader<MythicBukkit> defaultSkills;
    private List<IOLoader<MythicBukkit>> skillLoaders;
    private Map<String, Skill> skills = Maps.newConcurrentMap();
    private AuraManager auraManager;

    public SkillExecutor(MythicBukkit core) {
        super(core);
    }

    @Override
    public void load(MythicBukkit plugin) {
        MythicLogger.log(ConsoleColor.CYAN + "LOADED");
        this.auraManager = new AuraManager((MythicBukkit)this.getPlugin(), this);
        SkillExecutor.loadMechanics();
    }

    @Override
    public void unload() {
        MythicLogger.log(ConsoleColor.CYAN + "UNLOADED");
        this.auraManager.shutdown();
        Projectile.BULLET_ENTITIES.forEach(AbstractEntity::remove);
    }

    public void loadSkills() {
        MythicLogger.log("Loading Skills...");
        this.defaultSkills = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.getFile().getParent());
        File packsFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "Skills")).exists() || !confFolder.isDirectory()) continue;
                this.skillFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.skillLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), this.skillFiles, "Skills");
        this.skills.clear();
        for (IOLoader iOLoader : this.skillLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                String file = iOLoader.getFile().getPath();
                MythicConfigImpl mc = new MythicConfigImpl(name, iOLoader.getCustomConfig());
                MetaSkill ms = new MetaSkill(this, file, name, mc);
                this.skills.put(name, ms);
            }
        }
    }

    @Override
    public void queueAfterLoad(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueAfterLoad(r);
    }

    @Override
    public void queueSecondPass(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueSecondPass(r);
    }

    @Override
    public void registerSkill(String internalName, Skill skill) {
        this.skills.put(internalName, skill);
    }

    @Override
    public Optional<Skill> getSkill(String internalName) {
        if (internalName == null) {
            return Optional.empty();
        }
        if ((internalName = internalName.trim()).startsWith("[") && internalName.endsWith("]")) {
            internalName = internalName.substring(1, internalName.length() - 1);
            internalName = MythicLineConfigImpl.unparseBlock(internalName);
            String[] split = internalName.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            MetaSkill skill = new MetaSkill(this, elements);
            String skillName = skill.getInternalName();
            this.skills.put(skillName, skill);
            return Optional.of(skill);
        }
        if (this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    @Override
    public Collection<String> getSkillNames() {
        return this.skills.keySet();
    }

    @Override
    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    public void runTimerSkills(long timer) {
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (am == null || am.getEntity() == null || am.getType() == null) continue;
            am.tick(timer, ConfigExecutor.ClockInterval);
            if (am.isDead() || am.getEntity() == null || !am.getEntity().isValid() || !am.getType().isUsingTimers()) continue;
            this.executeMobTimerSkills(am, timer);
            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "---- Executed TIMER skills", new Object[0]);
        }
    }

    public void executeMobTimerSkills(ActiveMob am, long timer) {
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.TIMER, am, null);
        data.setPower(am.getPower());
        for (SkillMechanic skill : am.getType().getTimerSkills()) {
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSkillNew(am.getType().getInternalName() + ":" + skill.line);
            if ((double)timer % ((double)skill.interval / (double)ConfigExecutor.ClockInterval) == 0.0 && skill.isUsableFromCaster(data)) {
                skill.execute(data);
            }
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSkillComplete(am.getType().getInternalName() + ":" + skill.line);
        }
    }

    public ImmutableMap<String, Class<? extends SkillMechanic>> getMechanics() {
        return ImmutableMap.copyOf(MECHANICS);
    }

    private static void loadMechanics() {
    }

    @Override
    public SkillMechanic getMechanic(String skill) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Matching mechanic to string: {0}", skill);
        String[] s2 = skill.split(" ");
        String name = null;
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Matching MythicSkill type to {0}", name.toUpperCase());
        if (MECHANICS.containsKey(name.toUpperCase())) {
            Class<? extends SkillMechanic> clazz = MECHANICS.get(name.toUpperCase());
            try {
                return clazz.getConstructor(SkillExecutor.class, String.class, MythicLineConfig.class).newInstance(this, skill, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct mechanic {0}", skill);
                e.printStackTrace();
            }
        }
        try {
            if (name.toUpperCase().startsWith("SKILL:") || name.toUpperCase().startsWith("META:")) {
                String skillName = name.split(":")[1];
                return new MetaSkillMechanic(this, skill, skillName, mlc);
            }
            switch (name.toUpperCase()) {
                case "SENDTITLE": 
                case "TITLE": {
                    return new SendTitleMechanic(this, skill, mlc);
                }
                case "SENDRESOURCEPACK": 
                case "RESOURCEPACK": {
                    return new SendResourcePackMechanic(this, skill, mlc);
                }
                case "SETHEALTH": 
                case "SETHP": {
                    return new SetHealthMechanic(this, skill, mlc);
                }
                case "SETMAXHEALTH": 
                case "SETMAXHP": {
                    return new SetMaxHealthMechanic(this, skill, mlc);
                }
                case "SCORE": 
                case "MODIFYSCORE": {
                    return new ModifyScoreMechanic(this, skill, mlc);
                }
                case "SETBLOCKTYPE": 
                case "SETBLOCK": {
                    return new SetBlockTypeMechanic(this, skill, mlc);
                }
                case "SETGLIDING": {
                    return new SetGlidingMechanic(this, skill, mlc);
                }
                case "SETGLOBALSCORE": 
                case "SGS": {
                    return new SetGlobalScoreMechanic(this, skill, mlc);
                }
                case "SETMOBSCORE": 
                case "SMS": {
                    return new SetMobScoreMechanic(this, skill, mlc);
                }
                case "SETOWNER": {
                    return new SetOwnerMechanic(this, skill, mlc);
                }
                case "SETTARGETSCORE": 
                case "STS": {
                    return new SetTargetScoreMechanic(this, skill, mlc);
                }
                case "SETSTANCE": 
                case "STANCE": {
                    return new SetStanceMechanic(this, skill, mlc);
                }
                case "SETUSEGRAVITY": 
                case "SETGRAVITY": {
                    return new SetUseGravityMechanic(this, skill, mlc);
                }
                case "SHIELD": {
                    return new ShieldMechanic(this, skill, mlc);
                }
                case "SHIELDPERCENT": {
                    return new ShieldPercentMechanic(this, skill, mlc);
                }
                case "SHOOTFIREBALL": 
                case "FIREBALL": {
                    return new ShootFireballMechanic(this, skill, mlc);
                }
                case "SHOOTSKULL": 
                case "SKULL": 
                case "WITHERSKULL": {
                    return new ShootSkullMechanic(this, skill, mlc);
                }
                case "SIGNAL": 
                case "SENDSIGNAL": {
                    return new SignalMechanic(this, skill, mlc);
                }
                case "SPRING": 
                case "WATER": {
                    return new SpringMechanic(this, skill, mlc);
                }
                case "SUMMON": 
                case "SPAWNMOBS": {
                    return new SummonMechanic(this, skill, mlc);
                }
                case "SUMMONPASSENGER": 
                case "PASSENGER": 
                case "SUMMONRIDER": 
                case "RIDER": {
                    return new SummonPassengerMechanic(this, skill, mlc);
                }
                case "VARIABLESET": 
                case "SETVARIABLE": 
                case "SETVAR": {
                    return new VariableSetMechanic(this, skill, mlc);
                }
                case "VARIABLEADD": 
                case "ADDVARIABLE": 
                case "ADDVAR": 
                case "INCREMENTVARIABLE": {
                    return new VariableAddMechanic(this, skill, mlc);
                }
                case "VARIABLESUBTRACT": 
                case "VARIABLESUB": 
                case "SUBVARIABLE": 
                case "SUBVAR": 
                case "DECREMENTVARIABLE": {
                    return new VariableSubtractMechanic(this, skill, mlc);
                }
            }
            return new CustomMechanic(this, name.toUpperCase(), skill, mlc);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to load skill line due to bad syntax: {0} ", skill);
            if (ConfigExecutor.debugLevel > 0) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public ImmutableMap<String, Class<? extends SkillTargeter>> getTargeters() {
        return ImmutableMap.copyOf(TARGETERS);
    }

    @Override
    public SkillTargeter getTargeter(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicTargeter type to " + search, new Object[0]);
        ImmutableMap<String, Class<? extends SkillTargeter>> TARGETERS = ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeters();
        if (TARGETERS.containsKey(search.toUpperCase())) {
            Class clazz = (Class)TARGETERS.get(search.toUpperCase());
            try {
                return (SkillTargeter)clazz.getConstructor(SkillExecutor.class, MythicLineConfig.class).newInstance(this, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct targeter {0}", search);
                e.printStackTrace();
            }
        }
        switch (search.toUpperCase()) {
            case "LIVINGINWORLD": 
            case "ENTITIESINWORLD": 
            case "LIVINGENTITIESINWORLD": 
            case "ALLINWORLD": 
            case "EIW": {
                return new LivingInWorldTargeter(this, mlc);
            }
            case "LIVINGNEARTARGETLOCATION": 
            case "LNTL": 
            case "LIVINGENTITIESNEARTARGETLOCATION": {
                return new LivingNearTargetLocationTargeter(this, mlc);
            }
            case "LOCATION": 
            case "LOC": 
            case "L": {
                return new LocationTargeter(this, mlc);
            }
            case "MOBSINRADIUS": 
            case "MOBS": 
            case "MIR": {
                return new MobsInRadiusTargeter(this, mlc);
            }
            case "NEARESTPLAYER": {
                return new NearestPlayerTargeter(this, mlc);
            }
            case "PASSENGER": 
            case "RIDER": {
                return new PassengerTargeter(this, mlc);
            }
            case "PLAYERSNEARTARGETLOCATION": 
            case "PNTL": {
                return new PlayersNearTargetLocationsTargeter(this, mlc);
            }
            case "PLAYERLOCATIONSSINRADIUS": 
            case "LOCATIONRADIUS": 
            case "PLR": 
            case "PLIR": {
                return new PlayerLocationsInRadiusTargeter(this, mlc);
            }
            case "PLAYERSINRING": 
            case "PRING": {
                return new PlayersInRingTargeter(this, mlc);
            }
            case "PLAYERSINWORLD": 
            case "WORLD": {
                return new PlayersInWorldTargeter(this, mlc);
            }
            case "PLAYERSONSERVER": 
            case "SERVER": {
                return new PlayersOnServerTargeter(this, mlc);
            }
            case "THREATTABLE": 
            case "THREATTARGETS": 
            case "TT": {
                return new ThreatTableTargeter(this, mlc);
            }
            case "THREATTABLEPLAYERS": 
            case "PLAYERSINTHREATTABLE": 
            case "TTP": {
                return new ThreatTablePlayersTargeter(this, mlc);
            }
            case "THREATTABLERANDOMTARGET": 
            case "RANDOMTHREATTARGET": 
            case "RTT": {
                return new ThreatTableRandomTargeter(this, mlc);
            }
            case "PLAYERSNEARORIGIN": 
            case "PLAYERSNEARSOURCE": {
                return new PlayersNearOriginTargeter(this, mlc);
            }
            case "MOBSNEARORIGIN": 
            case "MOBSNEARSOURCE": {
                return new MobsNearOriginTargeter(this, mlc);
            }
            case "PARENTENTITIES": 
            case "PE": {
                return new MPEntity(this, mlc);
            }
            case "PARENTLOCATIONS": 
            case "PL": {
                return new MPLocation(this, mlc);
            }
            case "PARENTMETA": 
            case "PM": {
                return new MPMeta(this, mlc);
            }
            case "CONSOLE": 
            case "NONE": {
                return new ConsoleTargeter(this, mlc);
            }
        }
        if (search.substring(1, 2).equals("[")) {
            switch (search.substring(0, 1).toLowerCase()) {
                case "p": 
                case "r": 
                case "a": 
                case "e": {
                    return new VanillaTargeter(this, mlc, mlc.getLine());
                }
            }
        }
        return new CustomTargeter(this, search.toUpperCase(), mlc);
    }

    @Override
    public SkillTargeter getTargeter(String strTarget) {
        String search = strTarget.substring(1);
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTargeter {0}", search);
        return ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeter(name, mlc);
    }

    @Override
    public AbstractLocation getLocationTarget(SkillTargeter targeter, SkillMetadata data) {
        AbstractLocation newOrigin;
        if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
            targeter = ((CustomTargeter)targeter).getTargeter().get();
        }
        if (targeter instanceof ILocationSelector) {
            Collection<AbstractLocation> locations = ((ILocationSelector)targeter).getLocations(data);
            newOrigin = (AbstractLocation)locations.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                Collections.shuffle(collected);
                return collected.stream();
            })).findFirst().get();
        } else {
            newOrigin = targeter instanceof TriggerLocationTargeter ? data.getTrigger().getLocation() : data.getOrigin();
        }
        return newOrigin;
    }

    public ImmutableMap<String, Class<? extends SkillCondition>> getConditions() {
        return ImmutableMap.copyOf(CONDITIONS);
    }

    @Override
    public SkillCondition getCondition(String condition) {
        if (((String)(condition = MythicLineConfigImpl.unparseBlock((String)condition))).contains("}")) {
            String sp1 = ((String)condition).substring(0, ((String)condition).indexOf("}"));
            String sp2 = ((String)condition).substring(((String)condition).indexOf("}"));
            String ns = sp1.replace(" ", "") + sp2;
            condition = ns;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, ": Normalized Condition string to: " + (String)condition, new Object[0]);
        }
        String[] s2 = ((String)condition).split(" ");
        String name = null;
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicCondition type to " + name, new Object[0]);
        ImmutableMap<String, Class<? extends SkillCondition>> CONDITIONS = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions();
        if (CONDITIONS.containsKey(name.toUpperCase())) {
            Class clazz = (Class)CONDITIONS.get(name.toUpperCase());
            try {
                return (SkillCondition)clazz.getConstructor(String.class, MythicLineConfig.class).newInstance(condition, mlc);
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Failed to construct condition {0}", condition);
                ex.printStackTrace();
                return new InvalidCondition((String)condition);
            }
        }
        try {
            return new CustomCondition(name, (String)condition, mlc);
        }
        catch (Error | Exception ex) {
            MythicLogger.error("Failed to load condition '" + name + "'");
            ex.printStackTrace();
            return new InvalidCondition((String)condition);
        }
    }

    @Override
    public List<SkillCondition> getConditions(List<String> block) {
        ArrayList<SkillCondition> conditions = null;
        for (String s2 : block) {
            SkillCondition sc = this.getCondition(s2 = MythicLineConfigImpl.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            if (conditions == null) {
                conditions = new ArrayList<SkillCondition>();
            }
            conditions.add(sc);
        }
        return conditions;
    }

    @Override
    public List<SkillCondition> getConditions(String block) {
        if (block.startsWith("[") && block.endsWith("]")) {
            block = block.substring(1, block.length() - 1);
            block = MythicLineConfigImpl.unparseBlock(block);
            String[] split = block.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            return this.getConditions(elements);
        }
        return null;
    }

    public ImmutableMap<String, Class<? extends SkillAudience>> getAudiences() {
        return ImmutableMap.copyOf(AUDIENCES);
    }

    @Override
    public SkillAudience getAudience(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching Audience type to " + search, new Object[0]);
        if (search.startsWith("@")) {
            return new TargeterAudience(MythicLineConfigImpl.of(search), search);
        }
        ImmutableMap<String, Class<? extends SkillAudience>> AUDIENCES = ((MythicBukkit)this.getPlugin()).getSkillManager().getAudiences();
        if (AUDIENCES.containsKey(search.toUpperCase())) {
            Class clazz = (Class)AUDIENCES.get(search.toUpperCase());
            try {
                return (SkillAudience)clazz.getConstructor(MythicLineConfig.class).newInstance(mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct audience {0}", search);
                e.printStackTrace();
            }
        }
        return new CustomAudience(mlc);
    }

    public AuraManager getAuraManager() {
        return this.auraManager;
    }

    static {
        Set<Class<?>> conditionsClasses = new VersionCompliantReflections("io.lumine.mythic.core.skills.conditions.all").getTypesAnnotatedWith(MythicCondition.class);
        for (Class<?> clazz : conditionsClasses) {
            try {
                String string = clazz.getAnnotation(MythicCondition.class).name();
                String[] stringArray = clazz.getAnnotation(MythicCondition.class).aliases();
                if (!SkillCondition.class.isAssignableFrom(clazz)) continue;
                CONDITIONS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    CONDITIONS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load condition {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> mechanicsClasses = new VersionCompliantReflections("io.lumine.mythic.core.skills.mechanics").getTypesAnnotatedWith(MythicMechanic.class);
        for (Class<?> clazz : mechanicsClasses) {
            try {
                String string = clazz.getAnnotation(MythicMechanic.class).name();
                String[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                if (!SkillMechanic.class.isAssignableFrom(clazz)) continue;
                MECHANICS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    MECHANICS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load mechanic {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.mythic.core.skills.targeters").getTypesAnnotatedWith(MythicTargeter.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicTargeter.class).name();
                String[] aliases = clazz.getAnnotation(MythicTargeter.class).aliases();
                if (!SkillTargeter.class.isAssignableFrom(clazz)) continue;
                TARGETERS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    TARGETERS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.mythic.core.skills.audience").getTypesAnnotatedWith(MythicAudience.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAudience.class).name();
                String[] aliases = clazz.getAnnotation(MythicAudience.class).aliases();
                if (!SkillAudience.class.isAssignableFrom(clazz)) continue;
                AUDIENCES.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    AUDIENCES.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load audience {0}", clazz.getCanonicalName());
            }
        }
    }
}

