/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.IEntityLocationComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.conditions.ConditionAction;
import io.lumine.mythic.core.skills.conditions.CustomCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.HashSet;
import java.util.Optional;

public class SkillCondition
implements ISkillCondition {
    protected String conditionVar = "0";
    protected ConditionAction ACTION = ConditionAction.REQUIRED;
    protected PlaceholderString actionVar = null;

    public static MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public SkillCondition(String line) {
        String[] split = line.split(" ");
        if (split.length < 2) {
            return;
        }
        if (ConditionAction.isAction(split[1])) {
            this.ACTION = ConditionAction.valueOf(split[1].toUpperCase());
            if (split.length > 2) {
                this.actionVar = PlaceholderString.of(split[2]);
            }
        } else {
            this.conditionVar = split[1];
            if (split.length > 2 && ConditionAction.isAction(split[2])) {
                this.ACTION = ConditionAction.valueOf(split[2].toUpperCase());
                if (split.length > 3) {
                    this.actionVar = PlaceholderString.of(split[3]);
                }
            }
        }
    }

    public boolean evaluateEntity(AbstractEntity t2) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(t2, ((IEntityCondition)condition).check(t2));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(t2, ((ILocationCondition)condition).check(t2.getLocation()));
        }
        return false;
    }

    public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t2) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(t2, ((IEntityCondition)condition).check(t2));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(t2, ((ILocationCondition)condition).check(t2.getLocation()));
        }
        if (condition instanceof IEntityComparisonCondition) {
            return this.handleOutcome(t2, ((IEntityComparisonCondition)condition).check(base, t2));
        }
        if (condition instanceof ILocationComparisonCondition) {
            return this.handleOutcome(t2, ((ILocationComparisonCondition)condition).check(base.getLocation(), t2.getLocation()));
        }
        if (this instanceof IEntityLocationComparisonCondition) {
            return this.handleOutcome(t2, ((IEntityLocationComparisonCondition)condition).check(base, t2.getLocation()));
        }
        return false;
    }

    public boolean evaluateCaster(SkillMetadata meta) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof ISkillMetaCondition) {
            return this.handleOutcome(meta, ((ISkillMetaCondition)condition).check(meta));
        }
        if (condition instanceof ICasterCondition) {
            return this.handleOutcome(meta, ((ICasterCondition)condition).check(meta.getCaster()));
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)condition).check(meta.getCaster().getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)condition).check(meta.getCaster().getLocation()));
        }
        return false;
    }

    public boolean evaluateTrigger(SkillMetadata meta) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getTrigger() == null) {
            return false;
        }
        if (this instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)condition).check(meta.getTrigger()));
        }
        if (this instanceof IEntityComparisonCondition) {
            return this.handleOutcome(meta, ((IEntityComparisonCondition)condition).check(meta.getCaster().getEntity(), meta.getTrigger()));
        }
        if (this instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)condition).check(meta.getTrigger().getLocation()));
        }
        if (this instanceof ILocationComparisonCondition) {
            return this.handleOutcome(meta, ((ILocationComparisonCondition)condition).check(meta.getCaster().getLocation(), meta.getTrigger().getLocation()));
        }
        if (this instanceof IEntityLocationComparisonCondition) {
            return this.handleOutcome(meta, ((IEntityLocationComparisonCondition)condition).check(meta.getCaster().getEntity(), meta.getTrigger().getLocation()));
        }
        return false;
    }

    public boolean evaluateTargets(SkillMetadata meta) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
            HashSet<AbstractEntity> targets = Sets.newHashSet(meta.getEntityTargets());
            targets.removeIf(target -> {
                if (target == null || target.isDead() || !target.isValid()) {
                    return true;
                }
                if (condition instanceof IEntityCondition) {
                    return !this.handleOutcome(meta, ((IEntityCondition)condition).check((AbstractEntity)target));
                }
                if (condition instanceof IEntityComparisonCondition) {
                    return !this.handleOutcome(meta, ((IEntityComparisonCondition)condition).check(meta.getCaster().getEntity(), (AbstractEntity)target));
                }
                if (condition instanceof ILocationCondition) {
                    return !this.handleOutcome(meta, ((ILocationCondition)condition).check(target.getLocation()));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !this.handleOutcome(meta, ((ILocationComparisonCondition)condition).check(meta.getCaster().getLocation(), target.getLocation()));
                }
                if (this instanceof IEntityLocationComparisonCondition) {
                    return this.handleOutcome(meta, ((IEntityLocationComparisonCondition)condition).check(meta.getCaster().getEntity(), target.getLocation()));
                }
                if (condition instanceof ISkillMetaComparisonCondition) {
                    return this.handleOutcome(meta, ((ISkillMetaComparisonCondition)condition).check(meta, (AbstractEntity)target));
                }
                return false;
            });
            meta.setEntityTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
            HashSet<AbstractLocation> targets = Sets.newHashSet(meta.getLocationTargets());
            targets.removeIf(target -> {
                if (condition instanceof ILocationCondition) {
                    return !this.handleOutcome(meta, ((ILocationCondition)condition).check((AbstractLocation)target));
                }
                if (condition instanceof ILocationComparisonCondition) {
                    return !this.handleOutcome(meta, ((ILocationComparisonCondition)condition).check(meta.getCaster().getLocation(), (AbstractLocation)target));
                }
                if (this instanceof IEntityLocationComparisonCondition) {
                    return this.handleOutcome(meta, ((IEntityLocationComparisonCondition)condition).check(meta.getCaster().getEntity(), (AbstractLocation)target));
                }
                return false;
            });
            meta.setLocationTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(rsp, ((IEntityCondition)condition).check(rsp.getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(rsp, ((ILocationCondition)condition).check(rsp.getLocation()));
        }
        return false;
    }

    public boolean evaluateSpawner(MythicSpawner spawner) {
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(spawner, ((ILocationCondition)condition).check(spawner.getLocation()));
        }
        return false;
    }

    public boolean evaluateDropper(DropMetadata meta) {
        if (!meta.getDropper().isPresent()) {
            return false;
        }
        SkillCaster dropper = meta.getDropper().get();
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof ICasterCondition) {
            return this.handleOutcome(meta, ((ICasterCondition)condition).check(dropper));
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)condition).check(dropper.getEntity()));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)condition).check(dropper.getLocation()));
        }
        return false;
    }

    public boolean evaluateDropCause(DropMetadata meta) {
        if (!meta.getCause().isPresent()) {
            return false;
        }
        AbstractEntity cause = meta.getCause().get();
        ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
        if (condition instanceof InvalidCondition) {
            return true;
        }
        if (condition instanceof IEntityCondition) {
            return this.handleOutcome(meta, ((IEntityCondition)condition).check(cause));
        }
        if (condition instanceof ILocationCondition) {
            return this.handleOutcome(meta, ((ILocationCondition)condition).check(cause.getLocation()));
        }
        return false;
    }

    private boolean handleOutcome(AbstractEntity entity, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    private boolean handleOutcome(SkillMetadata meta, boolean outcome) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Condition outcome {0} action {1}", new Object[]{outcome, this.ACTION});
        switch (this.ACTION) {
            case CAST: {
                if (!outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome true, executing other cast", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (!maybeSkill.isPresent() || !maybeSkill.get().isUsable(meta)) break;
                maybeSkill.get().execute(meta);
                break;
            }
            case CASTINSTEAD: {
                if (!outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome true, executing castInstead", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (maybeSkill.isPresent() && maybeSkill.get().isUsable(meta)) {
                    maybeSkill.get().execute(meta);
                }
                return false;
            }
            case ORELSECAST: {
                if (outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome false, executing orElseCast", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (maybeSkill.isPresent() && maybeSkill.get().isUsable(meta)) {
                    maybeSkill.get().execute(meta);
                }
                return false;
            }
            case CANCEL: 
            case FALSE: {
                if (outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return !outcome;
            }
            case POWER: {
                if (!outcome) break;
                try {
                    float powerMod = Float.valueOf(this.actionVar.get(meta)).floatValue();
                    meta.setPower(meta.getPower() * powerMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                if (!outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return outcome;
            }
        }
        return true;
    }

    private boolean handleOutcome(RandomSpawnPoint rsp, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case LEVEL: {
                try {
                    float levelMod = Float.valueOf(this.actionVar.get()).floatValue();
                    rsp.setLevelMod(levelMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    private boolean handleOutcome(DropMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    private boolean handleOutcome(MythicSpawner spawner, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: 
            case FALSE: {
                return !outcome;
            }
            case REQUIRED: 
            case TRUE: {
                return outcome;
            }
        }
        return true;
    }

    public void setAction(ConditionAction action) {
        this.ACTION = action;
    }

    public String getActionVariable() {
        return this.actionVar.get();
    }

    public String getConditionVar() {
        return this.conditionVar;
    }

    public void setConditionVar(String conditionVar) {
        this.conditionVar = conditionVar;
    }

    public ConditionAction getACTION() {
        return this.ACTION;
    }

    public PlaceholderString getActionVar() {
        return this.actionVar;
    }

    public void setActionVar(PlaceholderString actionVar) {
        this.actionVar = actionVar;
    }
}

