/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.packs;

import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.config.Scope;
import java.io.File;

public class PackImpl
implements Pack,
PropertyHolder {
    private static final StringProp NAME = Property.String(Scope.PACK, "Name");
    private static final StringProp AUTHOR = Property.String(Scope.PACK, "Author");
    private static final StringProp URL = Property.String(Scope.PACK, "URL");
    private static final StringProp VERSION = Property.String(Scope.PACK, "Version");
    private final File folder;
    private final String key;
    private String name;
    private String author;
    private String url;
    private String version;

    public PackImpl(MythicBukkit plugin) {
        this.folder = plugin.getDataFolder();
        this.key = "Mythic";
        this.name = "Mythic Base Pack";
        this.author = "";
        this.version = "";
        this.url = "https://www.mythiccraft.io";
    }

    public PackImpl(File folder) {
        this.folder = folder;
        this.key = folder.getName();
        File packinfo = new File(folder, "packinfo.yml");
        if (packinfo.exists() && packinfo.isFile()) {
            this.name = (String)NAME.fget((Object)packinfo, this);
            this.author = (String)AUTHOR.fget((Object)packinfo, this);
            this.url = (String)URL.fget((Object)packinfo, this);
            this.version = (String)VERSION.fget((Object)packinfo, this);
        }
        this.setDefaultData();
    }

    private void setDefaultData() {
        if (this.name == null) {
            this.name = this.folder.getName();
        }
        if (this.author == null) {
            this.author = "Unknown";
        }
        if (this.url == null) {
            this.url = "Unknown";
        }
        if (this.version == null) {
            this.version = "";
        }
    }

    @Override
    public String getPropertyNode() {
        return "";
    }

    public File getFolder() {
        return this.folder;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackImpl)) {
            return false;
        }
        PackImpl other = (PackImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$folder = this.getFolder();
        File other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "PackImpl(folder=" + this.getFolder() + ", key=" + this.getKey() + ", name=" + this.getName() + ", author=" + this.getAuthor() + ", url=" + this.getUrl() + ", version=" + this.getVersion() + ")";
    }
}

