/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.packs;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.packs.PackManager;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.packs.PackImpl;
import java.io.File;
import java.util.Map;

public class PackExecutor
extends ReloadableModule<MythicBukkit>
implements PackManager {
    private final Map<String, Pack> packs = Maps.newConcurrentMap();

    public PackExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadPacks();
    }

    @Override
    public void unload() {
        this.packs.clear();
    }

    public Pack registerPack(File folder) {
        PackImpl pack = new PackImpl(folder);
        this.packs.put(pack.getKey(), pack);
        return pack;
    }

    private void loadBasePack() {
        this.packs.put("", new PackImpl((MythicBukkit)this.getPlugin()));
    }

    public void loadPacks() {
        MythicLogger.log("Loading Packs...");
        this.packs.clear();
        this.loadBasePack();
        File baseFolder = this.getPacksFolder();
        if (!baseFolder.isDirectory()) {
            MythicLogger.error("Packs folder isn't folder?");
            return;
        }
        for (File packFolder : baseFolder.listFiles()) {
            if (!packFolder.isDirectory()) continue;
            this.registerPack(packFolder);
        }
    }

    private File getPacksFolder() {
        File packsFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (!packsFolder.exists()) {
            packsFolder.mkdir();
        }
        return packsFolder;
    }
}

