/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.ai.goals;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ai.Pathfinder;
import io.lumine.mythic.core.mobs.ai.PathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import org.bukkit.entity.LivingEntity;

@MythicAIGoal(name="goToParent", aliases={}, version="4.8", description="Path to the mob's parent")
public class GoToParentGoal
extends Pathfinder
implements PathfindingGoal {
    private double followRangeSq;
    private double minRangeSq;
    private float speed;
    private boolean dropTarget;

    public GoToParentGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.goalType = Pathfinder.GoalType.MOVE_LOOK;
        double def = 4.0;
        try {
            def = Double.valueOf(this.dataVar1);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        double followRange = mlc.getDouble(new String[]{"followrange", "fr", "r", "maxrange"}, def);
        this.followRangeSq = Math.pow(followRange, 2.0);
        double minRange = mlc.getDouble(new String[]{"minrange", "mr"}, def);
        this.minRangeSq = Math.pow(minRange, 2.0);
        float defSpeed = 1.0f;
        try {
            defSpeed = Float.valueOf(this.dataVar2).floatValue();
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        this.speed = mlc.getFloat(new String[]{"speed", "s"}, defSpeed);
        this.dropTarget = mlc.getBoolean(new String[]{"droptarget", "dt"}, true);
    }

    @Override
    public boolean shouldStart() {
        if (this.activeMob.getParent() == null || this.activeMob.getParent().getEntity().isDead() || !this.activeMob.getParent().getEntity().isValid()) {
            return false;
        }
        AbstractLocation destination = this.activeMob.getParent().getLocation();
        if (this.entity.getLocation().distanceSquared(destination) > this.followRangeSq) {
            if (this.dropTarget) {
                GoToParentGoal.ai().setTarget((LivingEntity)BukkitAdapter.adapt(this.entity), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void tick() {
        AbstractLocation destination = this.activeMob.getParent().getLocation();
        double dist = this.entity.getLocation().distanceSquared(destination);
        if (dist > 4096.0) {
            this.entity.teleport(destination);
        } else {
            GoToParentGoal.ai().navigateToLocation(this.entity, destination, this.speed);
        }
    }

    @Override
    public boolean shouldEnd() {
        if (this.activeMob.getParent() == null || this.activeMob.getParent().getEntity().isDead() || !this.activeMob.getParent().getEntity().isValid()) {
            return true;
        }
        AbstractLocation destination = this.activeMob.getParent().getLocation();
        return this.entity.getLocation().distanceSquared(destination) <= this.minRangeSq;
    }

    @Override
    public void end() {
    }
}

