/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.logging;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import java.io.File;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class MythicLogger {
    public static void log(String message) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + ConsoleColor.RESET);
    }

    public static void log(String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + ConsoleColor.RESET, params);
    }

    public static void log(Level level, String message) {
        MythicBukkit.inst().getLogger().log(level, message + ConsoleColor.RESET);
    }

    public static void log(Level level, String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(level, message + ConsoleColor.RESET, params);
    }

    public static void error(String message) {
        MythicLogger.log(Level.WARNING, message + ConsoleColor.RESET);
    }

    public static void error(String message, Object ... params) {
        MythicLogger.log(Level.WARNING, message + ConsoleColor.RESET, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex) {
        MythicLogger.log(Level.SEVERE, message + ConsoleColor.RESET);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (ConfigExecutor.debugLevel > 0) {
            ex.printStackTrace();
        }
        if (ConfigExecutor.errorLogging) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicBukkit.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex, Object ... params) {
        MythicLogger.log(Level.SEVERE, message + ConsoleColor.RESET, params);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (ConfigExecutor.debugLevel > 0) {
            ex.printStackTrace();
        }
        if (ConfigExecutor.errorLogging) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicBukkit.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    public static void errorGenericConfig(String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error: " + ConsoleColor.WHITE + error);
    }

    public static void errorGenericConfig(MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " LineConfig Error: " + ConsoleColor.WHITE + error);
    }

    public static void errorConditionConfig(SkillCondition condition, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Condition line '" + ConsoleColor.UNDERLINE + config.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorDropConfig(Drop drop, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Drop '" + ConsoleColor.UNDERLINE + drop.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFileName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorDropTableConfig(DropTable drop, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for DropTable '" + ConsoleColor.UNDERLINE + drop.getInternalName() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFileName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorEntityConfig(BukkitEntityType entity, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Mob '" + ConsoleColor.UNDERLINE + config.getKey() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFile().getName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorItemConfig(MythicItem item, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Item '" + ConsoleColor.UNDERLINE + config.getKey() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFile().getName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorMechanicConfig(SkillMechanic mechanic, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Mechanic line '" + ConsoleColor.UNDERLINE + config.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFileName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorMobConfig(MythicMob mob, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Mob '" + ConsoleColor.UNDERLINE + config.getKey() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFile().getName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Targeter line '" + ConsoleColor.UNDERLINE + config.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorSpawnConfig(RandomSpawner spawner, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for RandomSpawn '" + ConsoleColor.UNDERLINE + config.getKey() + ConsoleColor.RESET + ConsoleColor.YELLOW + "' in '" + config.getFile().getName() + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorCompatibility(String plugin, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Compatibility Error for '" + ConsoleColor.UNDERLINE + plugin + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void debug(DebugLevel level, String message, Object ... params) {
        if (ConfigExecutor.debugLevel == 0) {
            return;
        }
        if (ConfigExecutor.debugLevel < level.ordinal()) {
            return;
        }
        switch (level) {
            case INFO: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[i] " + message, params);
                return;
            }
            case SKILL: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "+--- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case SKILL_CHECK: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|----- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case SKILL_INFO: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|------- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case MECHANIC: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "~----------- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case CONDITION: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|--------? " + ConsoleColor.CYAN + message, params);
                return;
            }
            case TRIGGER: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "#- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case EVENT: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[e] " + message, params);
                return;
            }
            case CLOCK: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[c] " + message, params);
                return;
            }
        }
    }

    private MythicLogger() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static enum DebugLevel {
        NONE,
        INFO,
        SKILL,
        SKILL_CHECK,
        SKILL_INFO,
        MECHANIC,
        CONDITION,
        TRIGGER,
        EVENT,
        CLOCK;

    }
}

