/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.items.ItemManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemExecutor
extends ReloadableModule<MythicBukkit>
implements ItemManager,
Listener {
    private List<File> itemFiles;
    private IOLoader<MythicBukkit> defaultItems;
    private List<IOLoader<MythicBukkit>> itemLoaders;
    private ConcurrentHashMap<String, MythicItem> items = new ConcurrentHashMap();

    public ItemExecutor(MythicBukkit plugin) {
        super(plugin, false);
        this.load(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadItems(plugin);
    }

    @Override
    public void unload() {
        this.itemFiles = null;
        this.defaultItems = null;
        this.itemLoaders = null;
        this.items.clear();
    }

    private void loadItems(MythicBukkit plugin) {
        MythicLogger.log("Loading Items...");
        this.defaultItems = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleItems.yml", "Items");
        this.itemFiles = IOHandler.getAllFiles(this.defaultItems.getFile().getParent());
        File packsFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "Items")).exists() || !confFolder.isDirectory()) continue;
                this.itemFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.itemLoaders = IOHandler.getSaveLoad((MythicBukkit)this.getPlugin(), this.itemFiles, "Items");
        this.items.clear();
        ArrayList itemsUsingTemplates = Lists.newArrayList();
        for (IOLoader<MythicBukkit> sl : this.itemLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                try {
                    MythicConfig mc = plugin.getConfiguration().createConfig(name, sl.getFile(), sl.getCustomConfig());
                    MythicItem mi = new MythicItem(sl.getFile().getName(), name, mc);
                    this.registerItem(name, mi);
                }
                catch (Error | Exception ex) {
                    MythicLogger.error("Error loading item '" + name + "'. Enable debugging for a stack trace.");
                    if (ConfigExecutor.debugLevel <= 0) continue;
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public Collection<MythicItem> getItems() {
        return this.items.values();
    }

    @Override
    public Collection<String> getItemNames() {
        return this.items.keySet();
    }

    @Override
    public Optional<MythicItem> getItem(String name) {
        return Optional.ofNullable(this.items.getOrDefault(name, null));
    }

    @Override
    public String getMythicTypeFromItem(ItemStack item) {
        if (!this.isMythicItem(item)) {
            return null;
        }
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getString("MYTHIC_TYPE");
    }

    @Override
    public boolean isMythicItem(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).containsKey("MYTHIC_ITEM_VERSION");
    }

    @Override
    public int getItemVersion(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getInt("MYTHIC_ITEM_VERSION");
    }

    public ItemStack getItemStack(String name) {
        return this.getItemStack(name, 1);
    }

    public ItemStack getItemStack(String name, int amount) {
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(name);
        if (maybeItem.isPresent()) {
            return BukkitAdapter.adapt(maybeItem.get().generateItemStack(amount));
        }
        try {
            return new ItemStack(Material.valueOf((String)name.toUpperCase()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean registerItem(String internalName, MythicItem item) {
        if (this.items.containsKey(internalName)) {
            return false;
        }
        this.items.put(internalName, item);
        return true;
    }

    public String getItemAttribute(String input) {
        String attribute;
        if (ServerVersion.isBeforeOrEq(MinecraftVersions.v1_15)) {
            switch (input.toUpperCase()) {
                case "DAMAGE": 
                case "ATTACK_DAMAGE": 
                case "ATTACKDAMAGE": {
                    attribute = "generic.attackDamage";
                    break;
                }
                case "HEALTH": 
                case "MAX_HEALTH": 
                case "MAXHEALTH": 
                case "HP": {
                    attribute = "generic.maxHealth";
                    break;
                }
                case "MOVEMENT_SPEED": 
                case "MOVEMENTSPEED": 
                case "MOVESPEED": 
                case "RUNSPEED": 
                case "RUN_SPEED": {
                    attribute = "generic.movementSpeed";
                    break;
                }
                case "ATTACK_SPEED": 
                case "ATTACKSPEED": 
                case "WEAPON_SPEED": 
                case "WEAPONSPEED": {
                    attribute = "generic.attackSpeed";
                    break;
                }
                case "KNOCKBACK": 
                case "ATTACKKNOCKBACK": 
                case "ATTACK_KNOCKBACK": {
                    attribute = "generic.attackKnockback";
                    break;
                }
                case "KNOCKBACK_RESISTANCE": 
                case "KNOCKBACKRESISTANCE": 
                case "KNOCKBACKRESIST": {
                    attribute = "generic.knockbackResistance";
                    break;
                }
                case "ARMOR": {
                    attribute = "generic.armor";
                    break;
                }
                case "ARMOR_TOUGHNESS": 
                case "TOUGHNESS": 
                case "ARMORTOUGHNESS": {
                    attribute = "generic.armorToughness";
                    break;
                }
                case "LUCK": {
                    attribute = "generic.luck";
                    break;
                }
                default: {
                    attribute = input;
                    break;
                }
            }
        } else {
            switch (input.toUpperCase()) {
                case "DAMAGE": 
                case "ATTACK_DAMAGE": 
                case "ATTACKDAMAGE": {
                    attribute = "generic.attack_damage";
                    break;
                }
                case "HEALTH": 
                case "MAX_HEALTH": 
                case "MAXHEALTH": 
                case "HP": {
                    attribute = "generic.max_health";
                    break;
                }
                case "MOVEMENT_SPEED": 
                case "MOVEMENTSPEED": 
                case "MOVESPEED": 
                case "RUNSPEED": 
                case "RUN_SPEED": {
                    attribute = "generic.movement_speed";
                    break;
                }
                case "ATTACK_SPEED": 
                case "ATTACKSPEED": 
                case "WEAPON_SPEED": 
                case "WEAPONSPEED": {
                    attribute = "generic.attack_speed";
                    break;
                }
                case "KNOCKBACK": 
                case "ATTACKKNOCKBACK": 
                case "ATTACK_KNOCKBACK": {
                    attribute = "generic.attack_knockback";
                    break;
                }
                case "KNOCKBACK_RESISTANCE": 
                case "KNOCKBACKRESISTANCE": 
                case "KNOCKBACKRESIST": {
                    attribute = "generic.knockback_resistance";
                    break;
                }
                case "ARMOR": {
                    attribute = "generic.armor";
                    break;
                }
                case "ARMOR_TOUGHNESS": 
                case "TOUGHNESS": 
                case "ARMORTOUGHNESS": {
                    attribute = "generic.armor_toughness";
                    break;
                }
                case "LUCK": {
                    attribute = "generic.luck";
                    break;
                }
                default: {
                    attribute = input;
                }
            }
        }
        return attribute;
    }
}

