/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.ICommandDrop;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IIntangibleDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.drops.ILocationDrop;
import io.lumine.mythic.api.drops.IMessagingDrop;
import io.lumine.mythic.api.drops.IMultiDrop;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ExperienceDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class LootBag {
    private final DropMetadata metadata;
    private List<Drop> lootTable = new LinkedList<Drop>();
    private Map<Class, Drop> lootTableIntangible = new HashMap<Class, Drop>();

    public LootBag(DropMetadata meta) {
        this.metadata = meta;
    }

    public Collection<Drop> getDrops() {
        LinkedList<Drop> drops = new LinkedList<Drop>();
        drops.addAll(this.lootTable);
        drops.addAll(this.lootTableIntangible.values());
        return drops;
    }

    @Deprecated
    public LootBag add(Drop type) {
        return this.add(null, type);
    }

    public LootBag add(DropMetadata data, Drop type) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Adding Drop to LootBag: {0}", type.getLine());
        if (type instanceof IIntangibleDrop || type instanceof ExperienceDrop) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding Intangible Drop", new Object[0]);
            this.lootTableIntangible.merge(type.getClass(), type, (o, n) -> {
                Drop d = o.addAmount((Drop)n);
                return d;
            });
        } else if (type instanceof ICommandDrop) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding Command Drop", new Object[0]);
            this.lootTable.add(type);
        } else if (type instanceof IMultiDrop) {
            int amount = (int)type.getAmount();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of MultiDrop", amount);
            for (int i = 0; i < amount; ++i) {
                this.add(data, ((IMultiDrop)((Object)type)).get(this.metadata));
            }
        } else if (type instanceof IItemDrop) {
            if (type.getAmount() < 1.0) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Cannot drop < 0 of item, skipping: {0}", type.getLine());
            } else {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of item drop: {1}", type.getAmount(), type.getLine());
                this.lootTable.add(type);
            }
        } else if (type instanceof CustomDrop) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "-- Adding Custom Drop from API", new Object[0]);
            if (!((CustomDrop)type).getDrop().isPresent()) {
                return this;
            }
            type.rollAmount(data);
            this.lootTable.add(type);
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Adding {0} of drop: {1}", type.getAmount(), type.getLine());
            this.lootTable.add(type);
        }
        return this;
    }

    public LootBag add(DropMetadata data, LootBag other) {
        for (Drop type : other.getLootTableIntangible().values()) {
            this.lootTableIntangible.merge(type.getClass(), type, (o, n) -> o.addAmount((Drop)n));
        }
        for (Drop type : other.getLootTable()) {
            this.lootTable.add(type);
        }
        return this;
    }

    public void drop(AbstractLocation target) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Calling the drop method passing in an AbstractLocation only.", new Object[0]);
        Location loc = BukkitAdapter.adapt(target);
        for (Drop type : this.getDrops()) {
            IDrop drop;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Drop type {0} {1}", type.getLine(), type.getClass());
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (drop instanceof IItemDrop) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Calling drop with type of IItemDrop.", new Object[0]);
                AbstractItemStack stack = ((IItemDrop)drop).getDrop(this.metadata, amount);
                loc.getWorld().dropItem(loc, BukkitAdapter.adapt(stack));
                continue;
            }
            if (!(drop instanceof ILocationDrop)) continue;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Calling drop with type of ILocationDrop.", new Object[0]);
            ((ILocationDrop)drop).drop(target, this.metadata, amount);
        }
    }

    public void dropForEntityDeathEvent(AbstractLocation location, AbstractPlayer target, EntityDeathEvent event) {
    }

    public void give(AbstractPlayer player) {
        this.give(player, true);
    }

    public void give(AbstractPlayer player, boolean sendMessages) {
        Player p = BukkitAdapter.adapt(player);
        HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
        for (Drop drop : this.getDrops()) {
            IDrop drop2;
            double amount = drop.getAmount();
            if (drop instanceof CustomDrop) {
                if (((CustomDrop)drop).getDrop().isEmpty()) continue;
                drop2 = ((CustomDrop)drop).getDrop().get();
            } else {
                drop2 = drop;
            }
            if (drop2 instanceof IItemDrop) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Giving Item {0} with amount {1}", drop.getLine(), drop.getAmount());
                AbstractItemStack stack = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                ItemStack is = BukkitAdapter.adapt(stack);
                p.getInventory().addItem(new ItemStack[]{is});
            } else if (drop2 instanceof ExperienceDrop) {
                p.giveExp((int)amount);
            } else if (drop2 instanceof IIntangibleDrop) {
                ((IIntangibleDrop)drop2).giveDrop(player, this.metadata, amount);
            } else if (drop2 instanceof ICommandDrop) {
                DropMetadata dropMetadata = this.metadata;
                dropMetadata.setAmount((int)amount);
                ((ICommandDrop)((Object)drop)).dispatchCommand(player, dropMetadata, amount);
            }
            if (!(drop2 instanceof IMessagingDrop)) continue;
            messagingDrops.merge((IMessagingDrop)((Object)drop), amount, (n, o) -> n + o);
        }
        if (messagingDrops.size() > 0 && sendMessages) {
            for (Map.Entry entry : messagingDrops.entrySet()) {
                String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(this.metadata, (Double)entry.getValue());
                if (message == null) continue;
                player.sendMessage(message);
            }
        }
    }

    public void equip(AbstractEntity entity) {
        AbstractItemStack hand = null;
        AbstractItemStack offhand = null;
        AbstractItemStack head = null;
        AbstractItemStack chest = null;
        AbstractItemStack legs = null;
        AbstractItemStack feet = null;
        for (Drop type : this.getDrops()) {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            try {
                if (!(drop instanceof IItemDrop) || type.getDropVar() == null) continue;
                EquipSlot slot = EquipSlot.of(type.getDropVar().toUpperCase());
                switch (slot) {
                    case HAND: {
                        hand = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                    case FEET: {
                        feet = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                    case LEGS: {
                        legs = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                    case CHEST: {
                        chest = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                    case HEAD: {
                        head = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                    case OFFHAND: {
                        offhand = ((IItemDrop)drop).getDrop(this.metadata, amount);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (ConfigExecutor.debugLevel <= 0) continue;
                ex.printStackTrace();
            }
        }
        if (head != null) {
            entity.equipItemHead(head);
        }
        if (chest != null) {
            entity.equipItemChest(chest);
        }
        if (legs != null) {
            entity.equipItemLegs(legs);
        }
        if (feet != null) {
            entity.equipItemFeet(feet);
        }
        if (hand != null) {
            entity.equipItemMainHand(hand);
        }
        if (offhand != null) {
            entity.equipItemOffHand(offhand);
        }
    }

    public void equipOrGive(AbstractPlayer player) {
        boolean sendMessages = true;
        Player p = BukkitAdapter.adapt(player);
        AbstractItemStack hand = null;
        AbstractItemStack offhand = null;
        AbstractItemStack head = null;
        AbstractItemStack chest = null;
        AbstractItemStack legs = null;
        AbstractItemStack feet = null;
        HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
        block8: for (Drop drop : this.getDrops()) {
            IDrop drop2;
            double amount = drop.getAmount();
            if (drop instanceof CustomDrop) {
                if (((CustomDrop)drop).getDrop().isEmpty()) continue;
                drop2 = ((CustomDrop)drop).getDrop().get();
            } else {
                drop2 = drop;
            }
            if (drop instanceof IItemDrop) {
                if (drop.getDropVar() != null) {
                    EquipSlot slot = EquipSlot.of(drop.getDropVar().toUpperCase());
                    switch (slot) {
                        case HAND: {
                            hand = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                        case FEET: {
                            feet = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                        case LEGS: {
                            legs = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                        case CHEST: {
                            chest = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                        case HEAD: {
                            head = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                        case OFFHAND: {
                            offhand = ((IItemDrop)drop2).getDrop(this.metadata, amount);
                            continue block8;
                        }
                    }
                }
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Giving Item {0} with amount {1}", drop.getLine(), drop.getAmount());
                AbstractItemStack stack = ((IItemDrop)((Object)drop)).getDrop(this.metadata, amount);
                ItemStack is = BukkitAdapter.adapt(stack);
                p.getInventory().addItem(new ItemStack[]{is});
            } else if (drop2 instanceof ExperienceDrop) {
                p.giveExp(Numbers.floor(amount));
            } else if (drop2 instanceof IIntangibleDrop) {
                ((IIntangibleDrop)drop2).giveDrop(player, this.metadata, amount);
            }
            if (!(drop2 instanceof IMessagingDrop)) continue;
            messagingDrops.merge((IMessagingDrop)((Object)drop2), amount, (n, o) -> n + o);
        }
        if (messagingDrops.size() > 0 && sendMessages) {
            for (Map.Entry entry : messagingDrops.entrySet()) {
                String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(this.metadata, (Double)entry.getValue());
                if (message == null) continue;
                player.sendMessage(message);
            }
        }
        if (head != null) {
            player.equipItemHead(head);
        }
        if (chest != null) {
            player.equipItemChest(chest);
        }
        if (legs != null) {
            player.equipItemLegs(legs);
        }
        if (feet != null) {
            player.equipItemFeet(feet);
        }
        if (hand != null) {
            player.equipItemMainHand(hand);
        }
        if (offhand != null) {
            player.equipItemOffHand(offhand);
        }
    }

    public int size() {
        return this.lootTable.size();
    }

    public DropMetadata getMetadata() {
        return this.metadata;
    }

    public List<Drop> getLootTable() {
        return this.lootTable;
    }

    public Map<Class, Drop> getLootTableIntangible() {
        return this.lootTableIntangible;
    }

    public void setLootTable(List<Drop> lootTable) {
        this.lootTable = lootTable;
    }

    public void setLootTableIntangible(Map<Class, Drop> lootTableIntangible) {
        this.lootTableIntangible = lootTableIntangible;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootBag)) {
            return false;
        }
        LootBag other = (LootBag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DropMetadata this$metadata = this.getMetadata();
        DropMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        List<Drop> this$lootTable = this.getLootTable();
        List<Drop> other$lootTable = other.getLootTable();
        if (this$lootTable == null ? other$lootTable != null : !((Object)this$lootTable).equals(other$lootTable)) {
            return false;
        }
        Map<Class, Drop> this$lootTableIntangible = this.getLootTableIntangible();
        Map<Class, Drop> other$lootTableIntangible = other.getLootTableIntangible();
        return !(this$lootTableIntangible == null ? other$lootTableIntangible != null : !((Object)this$lootTableIntangible).equals(other$lootTableIntangible));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootBag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DropMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        List<Drop> $lootTable = this.getLootTable();
        result = result * 59 + ($lootTable == null ? 43 : ((Object)$lootTable).hashCode());
        Map<Class, Drop> $lootTableIntangible = this.getLootTableIntangible();
        result = result * 59 + ($lootTableIntangible == null ? 43 : ((Object)$lootTableIntangible).hashCode());
        return result;
    }

    public String toString() {
        return "LootBag(metadata=" + this.getMetadata() + ", lootTable=" + this.getLootTable() + ", lootTableIntangible=" + this.getLootTableIntangible() + ")";
    }
}

