/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.version;

import io.lumine.mythic.bukkit.utils.version.MinecraftVersion;
import io.lumine.mythic.bukkit.utils.version.NMSVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class ServerVersion {
    private static final MinecraftVersion MINECRAFT_VERSION = ServerVersion.getServerVersion();
    private static final NMSVersion NMS = NMSVersion.forMinecraftVersion(MINECRAFT_VERSION);
    private static final boolean IS_PAPER;
    private static final boolean IS_AIRPLANE;

    public static MinecraftVersion get() {
        return MINECRAFT_VERSION;
    }

    public static NMSVersion getNMS() {
        return NMS;
    }

    public static boolean isPaper() {
        return IS_PAPER;
    }

    public static boolean isAirplane() {
        return IS_AIRPLANE;
    }

    public static boolean isAfter(MinecraftVersion other) {
        return MINECRAFT_VERSION.compareTo(other) > 0;
    }

    public static boolean isAfterOrEq(MinecraftVersion other) {
        return MINECRAFT_VERSION.compareTo(other) >= 0;
    }

    public static boolean isBefore(MinecraftVersion other) {
        return MINECRAFT_VERSION.compareTo(other) < 0;
    }

    public static boolean isBeforeOrEq(MinecraftVersion other) {
        return MINECRAFT_VERSION.compareTo(other) <= 0;
    }

    public static boolean isBetween(MinecraftVersion o1, MinecraftVersion o2) {
        return ServerVersion.isAfterOrEq(o1) && ServerVersion.isBeforeOrEq(o2) || ServerVersion.isBeforeOrEq(o1) && ServerVersion.isAfterOrEq(o2);
    }

    public static boolean equals(MinecraftVersion other) {
        return MINECRAFT_VERSION.getMajor() == other.getMajor() && MINECRAFT_VERSION.getMinor() == other.getMinor() && MINECRAFT_VERSION.getBuild() == other.getBuild();
    }

    public static boolean eq(MinecraftVersion other) {
        return MINECRAFT_VERSION.getMajor() == other.getMajor() && MINECRAFT_VERSION.getMinor() == other.getMinor() && MINECRAFT_VERSION.getBuild() == other.getBuild();
    }

    private static MinecraftVersion getServerVersion() {
        String versionString = Bukkit.getVersion();
        Matcher version = Pattern.compile(".*\\(.*MC.\\s*([a-zA-z0-9\\-\\.]+)\\s*\\)").matcher(versionString);
        if (version.matches() && version.group(1) != null) {
            return MinecraftVersion.parse(version.group(1));
        }
        throw new IllegalStateException("Cannot parse version String '" + versionString + "'");
    }

    static {
        boolean paper = false;
        try {
            paper = Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData") != null;
        }
        catch (ClassNotFoundException ex) {
            paper = false;
        }
        IS_PAPER = paper;
        boolean airplane = false;
        try {
            airplane = Class.forName("gg.airplane.AirplaneConfig") != null;
        }
        catch (ClassNotFoundException ex) {
            airplane = false;
        }
        IS_AIRPLANE = airplane;
    }
}

