/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.storage.players.adapters;

import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.PluginModule;
import io.lumine.mythic.bukkit.utils.profiles.MojangApi;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.storage.players.PlayerStorageAdapter;
import io.lumine.mythic.bukkit.utils.storage.players.Profile;
import java.io.File;
import java.util.Optional;
import java.util.UUID;

public abstract class FilePlayerStorageAdapter<T extends LuminePlugin, P extends Profile>
extends PluginModule<T>
implements PlayerStorageAdapter<P> {
    private final File dataDirectory;
    private final File storageDirectory;

    public FilePlayerStorageAdapter(T plugin) {
        super(plugin, false);
        this.dataDirectory = new File(plugin.getDataFolder(), "data");
        this.storageDirectory = new File(this.dataDirectory, "players");
        if (!this.dataDirectory.exists()) {
            this.dataDirectory.mkdir();
        }
        if (!this.storageDirectory.exists()) {
            this.storageDirectory.mkdir();
        }
    }

    @Override
    public Promise<Optional<P>> loadByName(String key) {
        return MojangApi.usernameToUuid(key).thenComposeAsync(uuid -> this.load((UUID)uuid));
    }

    protected abstract File getFile(String var1);

    public File getStorageDirectory() {
        return this.storageDirectory;
    }
}

