/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import io.lumine.mythic.bukkit.utils.serialize.Zone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public final class Region
implements GsonSerializable {
    private final Position min;
    private final Position max;
    private final double width;
    private final double height;
    private final double depth;

    public static Region deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("min"));
        Preconditions.checkArgument(object.has("max"));
        Position a = Position.deserialize(object.get("min"));
        Position b = Position.deserialize(object.get("max"));
        return Region.of(a, b);
    }

    public static Region of(Position a, Position b) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        if (!a.getWorld().equals(b.getWorld())) {
            throw new IllegalArgumentException("positions are in different worlds");
        }
        return new Region(a, b);
    }

    private Region(Position a, Position b) {
        this.min = Position.of(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()), a.getWorld());
        this.max = Position.of(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()), a.getWorld());
        this.width = this.max.getX() - this.min.getX();
        this.height = this.max.getY() - this.min.getY();
        this.depth = this.max.getZ() - this.min.getZ();
    }

    public boolean inRegion(Position pos) {
        Objects.requireNonNull(pos, "pos");
        return pos.getWorld().equals(this.min.getWorld()) && this.inRegion(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean inRegion(Location loc) {
        Objects.requireNonNull(loc, "loc");
        return loc.getWorld().getName().equals(this.min.getWorld()) && this.inRegion(loc.getX(), loc.getY(), loc.getZ());
    }

    public boolean inRegion(double x, double y, double z) {
        return x >= this.min.getX() && x <= this.max.getX() && y >= this.min.getY() && y <= this.max.getY() && z >= this.min.getZ() && z <= this.max.getZ();
    }

    public boolean inRegion(Region region) {
        Objects.requireNonNull(region, "region");
        return this.inRegion(region.getMin()) && this.inRegion(region.getMax());
    }

    public boolean intersects(Region region) {
        Objects.requireNonNull(region, "region");
        Position selectionMin = this.getMin();
        Position selectionMax = this.getMax();
        Position regionMin = region.getMin();
        Position regionMax = region.getMax();
        return (regionMin.getX() <= selectionMax.getX() && regionMin.getX() >= selectionMin.getX() || regionMax.getX() <= selectionMax.getX() && regionMax.getX() >= selectionMin.getX() || selectionMin.getX() >= regionMin.getX() && selectionMin.getX() <= regionMax.getX() || selectionMax.getX() >= regionMin.getX() && selectionMax.getX() <= regionMax.getX()) && (regionMin.getY() <= selectionMax.getY() && regionMin.getY() >= selectionMin.getY() || regionMax.getY() <= selectionMax.getY() && regionMax.getY() >= selectionMin.getY() || selectionMin.getY() >= regionMin.getY() && selectionMin.getY() <= regionMax.getY() || selectionMax.getY() >= regionMin.getY() && selectionMax.getY() <= regionMax.getY()) && (regionMin.getZ() <= selectionMax.getZ() && regionMin.getZ() >= selectionMin.getZ() || regionMax.getZ() <= selectionMax.getZ() && regionMax.getZ() >= selectionMin.getZ() || selectionMin.getZ() >= regionMin.getZ() && selectionMin.getZ() <= regionMax.getZ() || selectionMax.getZ() >= regionMin.getZ() && selectionMax.getZ() <= regionMax.getZ());
    }

    public Zone toZone() {
        return Zone.of(this.min.toLocus(), this.max.toLocus());
    }

    public Position getMin() {
        return this.min;
    }

    public Position getMax() {
        return this.max;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("min", this.min).add("max", this.max).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region other = (Region)o;
        return this.getMin().equals(other.getMin()) && this.getMax().equals(other.getMax());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMin().hashCode();
        result = result * 59 + this.getMax().hashCode();
        return result;
    }

    public String toString() {
        return "Region(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    public Collection<Entity> getEntities() {
        return this.getEntities(null);
    }

    public Collection<Entity> getEntities(Predicate<Entity> predicate) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        World world = Bukkit.getWorld((String)this.getMin().getWorld());
        int smallX = (int)(Math.floor(this.getMin().getX()) / 16.0);
        int bigX = (int)Math.floor(this.getMax().getX() / 16.0);
        int smallZ = (int)Math.floor(this.getMin().getZ() / 16.0);
        int bigZ = (int)Math.floor(this.getMax().getZ() / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = world.getChunkAt(x, z);
                if (null == chunk) continue;
                for (Entity entity : chunk.getEntities()) {
                    if (predicate != null && !predicate.test(entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    public Collection<Block> getBlocks() {
        int minX = (int)Math.floor(this.getMin().getX());
        int minY = (int)Math.floor(this.getMin().getY());
        int minZ = (int)Math.floor(this.getMin().getZ());
        int maxX = (int)Math.floor(this.getMax().getX());
        int maxY = (int)Math.floor(this.getMax().getY());
        int maxZ = (int)Math.floor(this.getMax().getZ());
        ArrayList<Block> blocks = Lists.newArrayList();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blocks.add(new Location(this.getMax().toLocation().getWorld(), (double)x, (double)y, (double)z).getBlock());
                }
            }
        }
        return blocks;
    }

    public Region transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        Position pos1 = this.min.transform2D(angle, aboutX, aboutZ, translateX, translateZ);
        Position pos2 = this.max.transform2D(angle, aboutX, aboutZ, translateX, translateZ);
        return Region.of(pos1, pos2);
    }
}

