/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis.params;

import io.lumine.mythic.bukkit.utils.redis.jedis.Protocol;
import io.lumine.mythic.bukkit.utils.redis.jedis.StreamEntryID;
import io.lumine.mythic.bukkit.utils.redis.jedis.params.Params;
import io.lumine.mythic.bukkit.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;

public class XPendingParams
extends Params {
    private Long idle;
    private String consumer;
    private StreamEntryID start;
    private StreamEntryID end;
    private Integer count;

    public static XPendingParams xPendingParams() {
        return new XPendingParams();
    }

    public XPendingParams idle(long idle) {
        this.idle = idle;
        return this;
    }

    public XPendingParams start(StreamEntryID start) {
        this.start = start;
        return this;
    }

    public XPendingParams end(StreamEntryID end) {
        this.end = end;
        return this;
    }

    public XPendingParams count(int count) {
        this.count = count;
        return this;
    }

    public XPendingParams consumer(String consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public byte[][] getByteParams() {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        if (this.idle != null) {
            byteParams.add(Protocol.Keyword.IDLE.getRaw());
            byteParams.add(Protocol.toByteArray(this.idle));
        }
        if (this.start == null) {
            byteParams.add(SafeEncoder.encode("-"));
        } else {
            byteParams.add(SafeEncoder.encode(this.start.toString()));
        }
        if (this.end == null) {
            byteParams.add(SafeEncoder.encode("+"));
        } else {
            byteParams.add(SafeEncoder.encode(this.end.toString()));
        }
        if (this.count != null) {
            byteParams.add(Protocol.toByteArray(this.count));
        }
        if (this.consumer != null) {
            byteParams.add(SafeEncoder.encode(this.consumer));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

