/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedLong {
    protected final Operation op;
    protected long min;
    protected long max;

    public RangedLong(String value) {
        this(value, false);
    }

    public RangedLong(String value, boolean squared) {
        if (value.contains("to")) {
            String[] split = value.split("to");
            this.min = Integer.valueOf(split[0]).intValue();
            this.max = Integer.valueOf(split[1]).intValue();
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            String[] split = value.split("-");
            this.min = Integer.valueOf(split[0]).intValue();
            this.max = Integer.valueOf(split[1]).intValue();
            this.op = Operation.RANGE;
        } else if (value.startsWith(">")) {
            String s2 = value.substring(1);
            this.min = Integer.valueOf(s2).intValue();
            this.max = Integer.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            String s3 = value.substring(1);
            this.min = Integer.MIN_VALUE;
            this.max = Integer.valueOf(s3).intValue();
            this.op = Operation.LESS_THAN;
        } else {
            this.min = Integer.valueOf(value).intValue();
            this.max = Integer.valueOf(value).intValue();
            this.op = Operation.EQUALS;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof Number) {
            long d = (Long)o;
            switch (this.op) {
                case EQUALS: {
                    return d == this.min;
                }
                case GREATER_THAN: {
                    return d > this.min;
                }
                case LESS_THAN: {
                    return d < this.max;
                }
                case RANGE: {
                    return d >= this.min && d <= this.max;
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "RangedLong{Amount=" + this.min + " to " + this.max + ", Operation=" + this.op + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        LESS_THAN,
        RANGE;

    }
}

