/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedInt {
    protected final Operation op;
    protected int min;
    protected int max;

    public RangedInt(String value) {
        this(value, false);
    }

    public RangedInt(String value, boolean squared) {
        if (value.contains("to")) {
            String[] split = value.split("to");
            this.min = Integer.valueOf(split[0]);
            this.max = Integer.valueOf(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            String[] split = value.split("-");
            this.min = Integer.valueOf(split[0]);
            this.max = Integer.valueOf(split[1]);
            this.op = Operation.RANGE;
        } else if (value.startsWith(">")) {
            String s2 = value.substring(1);
            this.min = Integer.valueOf(s2);
            this.max = Integer.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            String s3 = value.substring(1);
            this.min = Integer.MIN_VALUE;
            this.max = Integer.valueOf(s3);
            this.op = Operation.LESS_THAN;
        } else {
            this.min = Integer.valueOf(value);
            this.max = Integer.valueOf(value);
            this.op = Operation.EQUALS;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof Number) {
            int d = (Integer)o;
            switch (this.op) {
                case EQUALS: {
                    return d == this.min;
                }
                case GREATER_THAN: {
                    return d > this.min;
                }
                case LESS_THAN: {
                    return d < this.max;
                }
                case RANGE: {
                    return d >= this.min && d <= this.max;
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "RangedInt{Amount=" + this.min + " to " + this.max + ", Operation=" + this.op + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        LESS_THAN,
        RANGE;

    }
}

