/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import java.util.regex.Pattern;

public class RandomInt {
    private static Pattern PATTERN = Pattern.compile("^-?[0-9]*(to|-)?[0-9]\\d*");
    final boolean isStatic;
    final int min;
    final int max;

    public RandomInt(int i) {
        this.min = i;
        this.max = i;
        this.isStatic = true;
    }

    public RandomInt(int i, int j) {
        this.min = i;
        this.max = j;
        this.isStatic = false;
    }

    public RandomInt(String value) {
        try {
            if (value.contains("to")) {
                String[] split = value.split("to");
                this.min = Integer.valueOf(split[0]);
                this.max = Integer.valueOf(split[1]);
                this.isStatic = false;
            } else if (!value.startsWith("-") && value.contains("-")) {
                String[] split = value.split("-");
                this.min = Integer.valueOf(split[0]);
                this.max = Integer.valueOf(split[1]);
                this.isStatic = false;
            } else {
                this.min = Integer.valueOf(value);
                this.max = Integer.valueOf(value);
                this.isStatic = true;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public int get() {
        if (this.isStatic) {
            return this.min;
        }
        int rand = this.min + Numbers.randomInt(this.max - this.min + 1);
        return rand;
    }

    public String toString() {
        if (this.isStatic) {
            return String.valueOf(this.min);
        }
        return this.min + "to" + this.max;
    }

    public static boolean matches(String value) {
        return PATTERN.matcher(value).matches();
    }
}

