/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.metadata;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.lumine.mythic.bukkit.utils.cooldown.Cooldown;
import io.lumine.mythic.bukkit.utils.metadata.Empty;
import io.lumine.mythic.bukkit.utils.metadata.SimpleMetadataKey;
import java.util.UUID;

public interface MetadataKey<T> {
    public static <T> MetadataKey<T> create(String id, TypeToken<T> type) {
        Preconditions.checkNotNull(id, "id");
        Preconditions.checkNotNull(type, "type");
        return new SimpleMetadataKey<T>(id, type);
    }

    public static <T> MetadataKey<T> create(String id, Class<T> clazz) {
        return MetadataKey.create(id, TypeToken.of(clazz));
    }

    public static MetadataKey<Empty> createEmptyKey(String id) {
        return MetadataKey.create(id, Empty.class);
    }

    public static MetadataKey<String> createStringKey(String id) {
        return MetadataKey.create(id, String.class);
    }

    public static MetadataKey<Boolean> createBooleanKey(String id) {
        return MetadataKey.create(id, Boolean.class);
    }

    public static MetadataKey<Integer> createIntegerKey(String id) {
        return MetadataKey.create(id, Integer.class);
    }

    public static MetadataKey<Long> createLongKey(String id) {
        return MetadataKey.create(id, Long.class);
    }

    public static MetadataKey<Double> createDoubleKey(String id) {
        return MetadataKey.create(id, Double.class);
    }

    public static MetadataKey<Float> createFloatKey(String id) {
        return MetadataKey.create(id, Float.class);
    }

    public static MetadataKey<Short> createShortKey(String id) {
        return MetadataKey.create(id, Short.class);
    }

    public static MetadataKey<Character> createCharacterKey(String id) {
        return MetadataKey.create(id, Character.class);
    }

    public static MetadataKey<Cooldown> createCooldownKey(String id) {
        return MetadataKey.create(id, Cooldown.class);
    }

    public static MetadataKey<UUID> createUuidKey(String id) {
        return MetadataKey.create(id, UUID.class);
    }

    public String getId();

    public TypeToken<T> getType();

    public T cast(Object var1) throws ClassCastException;
}

