/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import com.google.common.collect.Maps;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.Menu;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.menu.MonitoredState;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.LoaderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MenuHelper
implements Listener {
    private static MenuHelper _instance = new MenuHelper();
    private final Map<UUID, OpenMenu<?>> openMenus = new HashMap();

    protected static <T> OpenMenu<T> registerOpen(Player player, Menu<T> menu, Inventory inventory, T state, List<MenuData<T>> data) {
        OpenMenu<T> om = new OpenMenu<T>(menu, player, inventory, state, data);
        MenuHelper._instance.openMenus.put(player.getUniqueId(), om);
        return om;
    }

    public static <T> OpenMenu<?> getOpenMenu(Player player) {
        return MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
    }

    public static <T> void reopenMenu(Player player, OpenMenu<T> menu) {
        MenuHelper._instance.openMenus.put(player.getUniqueId(), menu);
        player.openInventory(menu.getInventory());
        _instance.updateMenu(player.getUniqueId(), menu);
    }

    protected static <T> void moveToNextPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.nextPage();
            _instance.updateMenu(player.getUniqueId(), openMenu);
        } else {
            Log.info("moveToNextPage on unopened menu by {0}?", player.getName());
        }
    }

    protected static <T> void moveToPreviousPage(Player player) {
        OpenMenu openMenu = MenuHelper._instance.openMenus.getOrDefault(player.getUniqueId(), null);
        if (openMenu != null) {
            openMenu.previousPage();
            _instance.updateMenu(player.getUniqueId(), openMenu);
        } else {
            Log.info("moveToPreviousPage on unopened menu by {0}?", player.getName());
        }
    }

    private MenuHelper() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)LoaderUtils.getPlugin());
        Bukkit.getScheduler().runTaskTimer((Plugin)LoaderUtils.getPlugin(), this::updateMenus, 10L, 10L);
    }

    @EventHandler
    private void onOpen(InventoryOpenEvent event) {
        if (this.openMenus.containsKey(event.getPlayer().getUniqueId())) {
            OpenMenu<?> menu = this.openMenus.get(event.getPlayer().getUniqueId());
            menu.getMenu().getOpenFunc().accept(menu, event);
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        if (this.openMenus.containsKey(event.getPlayer().getUniqueId())) {
            OpenMenu<?> menu = this.openMenus.remove(event.getPlayer().getUniqueId());
            menu.getMenu().getCloseFunc().accept(menu, event);
        }
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        OpenMenu<?> openMenu = this.openMenus.get(event.getWhoClicked().getUniqueId());
        if (openMenu == null) {
            return;
        }
        if (openMenu.handleClick(event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onDrag(InventoryDragEvent event) {
        if (this.openMenus.containsKey(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private void updateMenus() {
        this.openMenus.forEach((uuid, menu) -> this.updateMenu((UUID)uuid, (OpenMenu)menu));
    }

    private <T> void updateMenu(UUID uuid, OpenMenu<T> openMenu) {
        Inventory inv;
        Player player;
        try {
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
                return;
            }
            inv = Bukkit.getPlayer((UUID)uuid).getOpenInventory().getTopInventory();
        }
        catch (Exception ex) {
            Player player2 = Bukkit.getPlayer((UUID)uuid);
            if (player2 == null) {
                player2.closeInventory();
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
            }
            return;
        }
        Menu menu = openMenu.menu;
        Player finalPlayer = player;
        Optional<MonitoredState> maybeMonitor = menu.getMonitoredState(openMenu.state);
        if (maybeMonitor.isPresent()) {
            if (!maybeMonitor.filter(monitor -> monitor.getMonitorTimestamp() != openMenu.monitorTimestamp).isPresent()) {
                if (menu.getBlinkingSlots().isPresent()) {
                    menu.getBlinkingSlots().get().stream().forEach(slot -> {
                        Icon icon = menu.getIcon((int)slot).get();
                        ItemStack stack = icon.build(openMenu.state, finalPlayer);
                        ItemStack comp = inv.getItem(slot.intValue());
                        if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                            inv.setItem(slot.intValue(), stack);
                        }
                    });
                }
                return;
            }
            openMenu.monitorTimestamp = maybeMonitor.get().getMonitorTimestamp();
        }
        menu.sort(openMenu.state);
        menu.getIcons().forEach((slot, icon) -> {
            ItemStack stack = icon.build(openMenu.state, finalPlayer);
            ItemStack comp = inv.getItem(slot.intValue());
            if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                inv.setItem(slot.intValue(), stack);
            }
        });
        if (!menu.getDataSlots().isEmpty() && openMenu.getData().size() > 0) {
            int count = 0;
            for (int slot2 : menu.getDataSlots()) {
                try {
                    ItemStack stack = count >= openMenu.getDisplayedData().size() ? new ItemStack(Material.AIR) : openMenu.getDisplayedData().get(count).getIcon().build(openMenu.state, finalPlayer);
                    ItemStack comp = inv.getItem(slot2);
                    if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
                        inv.setItem(slot2, stack);
                    }
                }
                catch (Error | Exception throwable) {
                    // empty catch block
                }
                ++count;
            }
        }
    }

    public static MenuHelper get_instance() {
        return _instance;
    }

    public Map<UUID, OpenMenu<?>> getOpenMenus() {
        return this.openMenus;
    }

    public static class OpenMenu<T> {
        private final Menu<T> menu;
        private final Player player;
        private final Inventory inventory;
        private final T state;
        private final List<MenuData<T>> data;
        private long monitorTimestamp;
        private int page = 0;
        private int pages = 1;
        private int dataPerPage = 0;
        private List<MenuData<T>> displayedData;
        private Map<Integer, Icon<T>> displayedIcons = Maps.newHashMap();

        public OpenMenu(Menu<T> menu, Player player, Inventory inventory, T state, List<MenuData<T>> data) {
            this.menu = menu;
            this.player = player;
            this.inventory = inventory;
            this.state = state;
            this.data = data;
            this.dataPerPage = menu.getDataSlots().size();
            if (this.dataPerPage > 0) {
                int start;
                int end = (start = this.page * this.dataPerPage) + this.dataPerPage;
                this.displayedData = data.subList(start, end < data.size() ? end : data.size());
                this.pages = Numbers.floor(data.size() / this.dataPerPage);
                int count = 0;
                for (int slot : menu.getDataSlots()) {
                    if (count < this.getDisplayedData().size()) {
                        this.displayedIcons.put(slot, this.getDisplayedData().get(count).getIcon());
                    }
                    ++count;
                }
            }
        }

        public boolean handleClick(InventoryClickEvent event) {
            if (!this.menu.getFreeSlots().isEmpty()) {
                if (event.getClickedInventory().getType() == InventoryType.PLAYER) {
                    return false;
                }
                if (this.menu.getFreeSlots().contains(event.getRawSlot())) {
                    return this.menu.getDefaultClickFunc() != null && this.menu.getDefaultClickFunc().apply(this, event.getRawSlot()) != false;
                }
            }
            if (event.getClick() == ClickType.RIGHT) {
                this.handleRightClick(event.getRawSlot());
            } else {
                this.handleClick(event.getRawSlot());
            }
            return true;
        }

        private void handleClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        private void handleRightClick(int slot) {
            this.getIcon(slot).ifPresent(icon -> icon.getRightClickFunc().ifPresent(func -> func.accept(this.state, this.player)));
        }

        public Optional<Icon<? super T>> getIcon(int slot) {
            if (this.menu.getDataSlots().contains(slot)) {
                return Optional.ofNullable(this.displayedIcons.getOrDefault(slot, null));
            }
            return this.menu.getIcon(slot);
        }

        public void setPage(int page) {
            int start;
            this.page = page;
            int end = (start = page * this.dataPerPage) + this.dataPerPage;
            this.displayedData = this.data.subList(start, end < this.data.size() ? end : this.data.size());
            int count = 0;
            this.displayedIcons.clear();
            for (int slot : this.menu.getDataSlots()) {
                if (count < this.getDisplayedData().size()) {
                    this.displayedIcons.put(slot, this.getDisplayedData().get(count).getIcon());
                }
                ++count;
            }
        }

        public void nextPage() {
            this.setPage(this.page + 1 > this.pages ? this.pages : this.page + 1);
        }

        public void previousPage() {
            this.setPage(this.page - 1 <= 0 ? 0 : this.page - 1);
        }

        public Menu<T> getMenu() {
            return this.menu;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public List<MenuData<T>> getData() {
            return this.data;
        }

        public int getPage() {
            return this.page;
        }

        public int getPages() {
            return this.pages;
        }

        public int getDataPerPage() {
            return this.dataPerPage;
        }

        public List<MenuData<T>> getDisplayedData() {
            return this.displayedData;
        }

        public Map<Integer, Icon<T>> getDisplayedIcons() {
            return this.displayedIcons;
        }
    }
}

