/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.menu.MenuHelper;
import io.lumine.mythic.bukkit.utils.menu.MonitoredState;
import io.lumine.mythic.bukkit.utils.menu.WrappedMenuData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;

public class Menu<T> {
    private final Function<T, String> titleFunc;
    private final Function<T, MonitoredState> monitorFunc;
    private BiConsumer<MenuHelper.OpenMenu<T>, InventoryOpenEvent> openFunc = (a, b) -> {};
    private BiConsumer<MenuHelper.OpenMenu<T>, InventoryCloseEvent> closeFunc = (a, b) -> {};
    private final Map<Integer, Icon<? super T>> icons;
    private BiFunction<MenuHelper.OpenMenu<T>, Integer, Boolean> defaultClickFunc;
    private int size = -1;
    private List<Integer> blinkSlots = Lists.newArrayList();
    private List<Integer> dataSlots = Lists.newArrayList();
    private List<Integer> freeSlots = Lists.newArrayList();
    private List<Integer> sortSlots = null;
    private int minSort;
    private int maxSort;

    public static <T> MenuBuilder<T> builder() {
        return new MenuBuilder();
    }

    protected Menu(Function<T, String> titleFunc, Function<T, MonitoredState> monitorFunc, Map<Integer, Icon<? super T>> icons) {
        this.titleFunc = titleFunc;
        this.monitorFunc = monitorFunc;
        this.icons = icons;
    }

    @Deprecated
    public Menu<T> setSize(int size) {
        this.size = size;
        return this;
    }

    protected Map<Integer, Icon<? super T>> getIcons() {
        return this.icons;
    }

    protected Optional<Icon<? super T>> getIcon(int slot) {
        return Optional.ofNullable(this.icons.get(slot));
    }

    public Menu<T> addIcon(int slot, Icon<? super T> icon) {
        this.icons.put(slot, icon);
        if (icon.isBlinkingIcon()) {
            this.blinkSlots.add(slot);
        }
        return this;
    }

    public Menu<T> createIcon(int slot, Function<IconBuilder<T>, IconBuilder<T>> builderFunc) {
        this.addIcon(slot, builderFunc.apply(IconBuilder.create()).build());
        return this;
    }

    protected Optional<List<Integer>> getBlinkingSlots() {
        return Optional.ofNullable(this.blinkSlots);
    }

    protected Optional<MonitoredState> getMonitoredState(T state) {
        if (this.monitorFunc == null) {
            return Optional.empty();
        }
        return Optional.of(this.monitorFunc.apply(state));
    }

    public void setSortSlots(List<Integer> sortable) {
        this.sortSlots = sortable;
        if (sortable == null) {
            return;
        }
        Optional maybeMinSort = sortable.stream().min(Comparator.naturalOrder());
        Optional maybeMaxSort = sortable.stream().max(Comparator.naturalOrder());
        if (!maybeMinSort.isPresent()) {
            this.sortSlots = null;
            return;
        }
        this.minSort = (Integer)maybeMinSort.get();
        if (!maybeMaxSort.isPresent()) {
            this.sortSlots = null;
            return;
        }
        this.maxSort = (Integer)maybeMaxSort.get();
    }

    protected void sort(final T state) {
        int i;
        if (this.sortSlots == null) {
            return;
        }
        ArrayList<Icon<T>> sort = new ArrayList<Icon<T>>();
        for (i = this.minSort; i <= this.maxSort; ++i) {
            if (!this.getIcon(i).isPresent()) continue;
            sort.add(this.getIcon(i).get());
        }
        Collections.sort(sort, new Comparator<Icon<? super T>>(){

            @Override
            public int compare(Icon<? super T> i1, Icon<? super T> i2) {
                int x1 = i1.getAmount(state);
                int x2 = i2.getAmount(state);
                return x2 - x1;
            }
        });
        i = this.minSort;
        for (Icon icon : sort) {
            this.icons.put(i, icon);
            ++i;
        }
    }

    protected int getMinSortedSlot() {
        return this.minSort;
    }

    protected int getMaxSortedSlot() {
        return this.maxSort;
    }

    public void open(Player player, T state) {
        this.open(player, state, Lists.newArrayList());
    }

    public void open(Player player, T state, List<?> in) {
        if (this.icons.isEmpty()) {
            throw new IllegalStateException("Tried to open an empty menu!");
        }
        ArrayList data = Lists.newArrayList();
        for (Object obj : in) {
            if (obj instanceof MenuData) {
                data.add((MenuData)obj);
                continue;
            }
            if (obj instanceof Icon) {
                data.add(new WrappedMenuData((Icon)obj));
                continue;
            }
            Log.error("Invalid menu data in menu opened by {0}", player.getName());
            Log.error("Menu: {0}", this.titleFunc.apply(state));
            Log.error("Data: {0}", obj.getClass().toString());
            throw new IllegalArgumentException("Invalid menu data passed");
        }
        int max = (Integer)this.icons.keySet().stream().sorted(Comparator.reverseOrder()).findFirst().get();
        int size = this.size;
        if (size < 0) {
            size = (int)Math.ceil((double)(max + 1) / 9.0) * 9;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)this.titleFunc.apply(state));
        this.sort(state);
        this.icons.forEach((slot, icon) -> inventory.setItem(slot.intValue(), icon.build(state, player)));
        if (this.dataSlots.size() > 0) {
            int start;
            int dataPerPage = this.dataSlots.size();
            int end = (start = 0 * dataPerPage) + dataPerPage;
            List displayedData = data.subList(start, end < data.size() ? end : data.size());
            int count = 0;
            for (int slot2 : this.dataSlots) {
                if (count >= displayedData.size()) break;
                try {
                    inventory.setItem(slot2, ((MenuData)displayedData.get(slot2)).getIcon().build(state, player));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (Error | Exception ex) {
                    ex.printStackTrace();
                }
                ++count;
            }
        }
        player.closeInventory();
        MenuHelper.registerOpen(player, this, inventory, state, data);
        player.openInventory(inventory);
    }

    public void nextPage(Player player) {
        MenuHelper.moveToNextPage(player);
    }

    public void previousPage(Player player) {
        MenuHelper.moveToPreviousPage(player);
    }

    public BiConsumer<MenuHelper.OpenMenu<T>, InventoryOpenEvent> getOpenFunc() {
        return this.openFunc;
    }

    public BiConsumer<MenuHelper.OpenMenu<T>, InventoryCloseEvent> getCloseFunc() {
        return this.closeFunc;
    }

    public BiFunction<MenuHelper.OpenMenu<T>, Integer, Boolean> getDefaultClickFunc() {
        return this.defaultClickFunc;
    }

    public void setDefaultClickFunc(BiFunction<MenuHelper.OpenMenu<T>, Integer, Boolean> defaultClickFunc) {
        this.defaultClickFunc = defaultClickFunc;
    }

    public int getSize() {
        return this.size;
    }

    public List<Integer> getBlinkSlots() {
        return this.blinkSlots;
    }

    public void setBlinkSlots(List<Integer> blinkSlots) {
        this.blinkSlots = blinkSlots;
    }

    public List<Integer> getDataSlots() {
        return this.dataSlots;
    }

    public void setDataSlots(List<Integer> dataSlots) {
        this.dataSlots = dataSlots;
    }

    public List<Integer> getFreeSlots() {
        return this.freeSlots;
    }

    public void setFreeSlots(List<Integer> freeSlots) {
        this.freeSlots = freeSlots;
    }

    public List<Integer> getSortSlots() {
        return this.sortSlots;
    }
}

