/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Icon<T> {
    private final Function<T, ItemStack> iconFunc;
    private final Function<T, Material> materialFunc;
    private final Function<T, Integer> modelFunction;
    private final Function<T, Integer> amountFunction;
    private final Function<T, String> nameFunc;
    private final Function<T, List<String>> loreFunc;
    private byte data = 0;
    private final Optional<BiConsumer<T, Player>> clickFunc;
    private final Optional<BiConsumer<T, Player>> rightClickFunc;
    private final Optional<Function<T, ItemStack>> blinkFunc;
    private ItemStack itemStack = null;
    private boolean hideFlags = false;
    private boolean blink = false;

    protected Icon(Function<T, Material> materialFunc, Function<T, String> nameFunc, Function<T, List<String>> loreFunc, BiConsumer<T, Player> clickFunc, BiConsumer<T, Player> rclickFunc, Function<T, Integer> byteFunction, Function<T, Integer> amountFunction, Function<T, ItemStack> blinkFunc, boolean hideFlags) {
        this.materialFunc = materialFunc;
        this.iconFunc = null;
        this.nameFunc = nameFunc;
        this.loreFunc = loreFunc;
        this.clickFunc = Optional.ofNullable(clickFunc);
        this.rightClickFunc = Optional.ofNullable(rclickFunc);
        this.modelFunction = byteFunction;
        this.amountFunction = amountFunction;
        this.blinkFunc = Optional.ofNullable(blinkFunc);
        this.hideFlags = hideFlags;
    }

    protected Icon(ItemStack itemStack, Function<T, String> nameFunc, Function<T, List<String>> loreFunc, BiConsumer<T, Player> clickFunc, BiConsumer<T, Player> rclickFunc, Function<T, Integer> byteFunction, Function<T, Integer> amountFunction, Function<T, ItemStack> blinkFunc, boolean hideFlags) {
        this.itemStack = itemStack;
        this.iconFunc = null;
        this.materialFunc = null;
        this.nameFunc = nameFunc;
        this.loreFunc = loreFunc;
        this.clickFunc = Optional.ofNullable(clickFunc);
        this.rightClickFunc = Optional.ofNullable(rclickFunc);
        this.modelFunction = byteFunction;
        this.amountFunction = amountFunction;
        this.blinkFunc = Optional.ofNullable(blinkFunc);
        this.hideFlags = hideFlags;
    }

    public Icon(Function<T, String> nameFunc, Function<T, List<String>> loreFunc, BiConsumer<T, Player> clickFunc, BiConsumer<T, Player> rclickFunc, Function<T, Integer> byteFunction, Function<T, Integer> amountFunction, Function<T, ItemStack> iconFunc, Function<T, ItemStack> blinkFunc, boolean hideFlags) {
        this.iconFunc = iconFunc;
        this.itemStack = null;
        this.materialFunc = null;
        this.nameFunc = nameFunc;
        this.loreFunc = loreFunc;
        this.clickFunc = Optional.ofNullable(clickFunc);
        this.rightClickFunc = Optional.ofNullable(rclickFunc);
        this.modelFunction = byteFunction;
        this.amountFunction = amountFunction;
        this.blinkFunc = Optional.ofNullable(blinkFunc);
        this.hideFlags = hideFlags;
    }

    public Icon<T> data(byte date) {
        this.data = date;
        return this;
    }

    public ItemStack build(T state, Player player) {
        int model;
        ItemStack stack = null;
        if (this.blinkFunc.isPresent()) {
            boolean bl = this.blink = !this.blink;
            if (this.blink) {
                stack = this.blinkFunc.get().apply(state);
            }
        }
        if (stack == null) {
            stack = this.itemStack != null ? this.itemStack.clone() : (this.iconFunc != null ? this.iconFunc.apply(state).clone() : new ItemStack(this.materialFunc.apply(state), this.getAmount(state)));
        }
        if (stack.getType() == Material.AIR) {
            return stack;
        }
        ItemMeta meta = stack.getItemMeta();
        if (this.nameFunc != null) {
            meta.setDisplayName(this.nameFunc.apply(state));
        } else {
            meta.setDisplayName(meta.getDisplayName());
        }
        if (this.loreFunc != null) {
            meta.setLore(this.loreFunc.apply(state));
        } else if (meta.hasLore()) {
            meta.setLore(meta.getLore());
        }
        stack.setItemMeta(meta);
        if (this.nameFunc == null && this.loreFunc == null) {
            return stack;
        }
        if (this.hideFlags) {
            meta.addItemFlags(ItemFlag.values());
        }
        int n = model = this.modelFunction == null ? this.data : this.modelFunction.apply(state);
        if (model > 0) {
            meta.setCustomModelData(Integer.valueOf(model));
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public int getAmount(T state) {
        return this.amountFunction == null ? 1 : this.amountFunction.apply(state);
    }

    public boolean isBlinkingIcon() {
        return this.blinkFunc.isPresent();
    }

    public Optional<BiConsumer<T, Player>> getClickFunc() {
        return this.clickFunc;
    }

    public Optional<BiConsumer<T, Player>> getRightClickFunc() {
        return this.rightClickFunc;
    }
}

