/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.client;

import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpHost;
import io.lumine.mythic.bukkit.utils.lib.http.HttpRequest;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.ThreadSafe;
import io.lumine.mythic.bukkit.utils.lib.http.client.ClientProtocolException;
import io.lumine.mythic.bukkit.utils.lib.http.client.config.RequestConfig;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.CloseableHttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.Configurable;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpExecutionAware;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpRequestWrapper;
import io.lumine.mythic.bukkit.utils.lib.http.client.protocol.HttpClientContext;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ClientConnectionManager;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ClientConnectionRequest;
import io.lumine.mythic.bukkit.utils.lib.http.conn.HttpClientConnectionManager;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ManagedClientConnection;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoute;
import io.lumine.mythic.bukkit.utils.lib.http.conn.scheme.SchemeRegistry;
import io.lumine.mythic.bukkit.utils.lib.http.impl.DefaultConnectionReuseStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.impl.client.CloseableHttpClient;
import io.lumine.mythic.bukkit.utils.lib.http.impl.client.DefaultConnectionKeepAliveStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.impl.execchain.MinimalClientExec;
import io.lumine.mythic.bukkit.utils.lib.http.params.BasicHttpParams;
import io.lumine.mythic.bukkit.utils.lib.http.params.HttpParams;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.BasicHttpContext;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.HttpRequestExecutor;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

