/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.items;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils {
    public static boolean containsItem(Player player, Material material, int amount) {
        return InventoryUtils.containsItem((Inventory)player.getInventory(), new ItemStack(material), amount);
    }

    public static boolean containsItem(Inventory inventory, Material material, int amount) {
        return InventoryUtils.containsItem(inventory, new ItemStack(material), amount);
    }

    public static boolean containsItem(Player player, ItemStack item, int amount) {
        return InventoryUtils.containsItem((Inventory)player.getInventory(), item, amount);
    }

    public static boolean containsItem(Inventory inventory, ItemStack item, int amount) {
        int found = 0;
        for (ItemStack i : inventory.getContents()) {
            if (!item.isSimilar(i)) continue;
            found += i.getAmount();
        }
        return found >= amount;
    }

    public static int removeItems(Player player, Material material, int amount) {
        return InventoryUtils.removeItems((Inventory)player.getInventory(), new ItemStack(material), amount);
    }

    public static int removeItems(Inventory inventory, Material material, int amount) {
        return InventoryUtils.removeItems(inventory, new ItemStack(material), amount);
    }

    public static int removeItems(Player player, ItemStack item, int amount) {
        return InventoryUtils.removeItems((Inventory)player.getInventory(), item, amount);
    }

    public static int removeItems(Inventory inventory, ItemStack item, int amount) {
        for (ItemStack stack : inventory) {
            if (!item.isSimilar(stack)) continue;
            int stackAmount = stack.getAmount();
            if (stackAmount > amount) {
                stack.setAmount(stackAmount - amount);
            } else {
                stack.setAmount(0);
            }
            if ((amount -= stackAmount) > 0) continue;
            break;
        }
        return amount;
    }

    private InventoryUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

