/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.holograms.individual;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.holograms.individual.HologramLine;
import io.lumine.mythic.bukkit.utils.holograms.individual.IndividualHologram;
import io.lumine.mythic.bukkit.utils.holograms.individual.IndividualHologramFactory;
import io.lumine.mythic.bukkit.utils.protocol.Protocol;
import io.lumine.mythic.bukkit.utils.reflection.ServerReflection;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import io.lumine.mythic.bukkit.utils.terminable.composite.CompositeTerminable;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersion;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerQuitEvent;

public class PacketIndividualHologramFactory
implements IndividualHologramFactory {
    private static final Method GET_HANDLE_METHOD;
    private static final Method GET_ID_METHOD;

    private static int getEntityId(Entity entity) {
        try {
            Object handle = GET_HANDLE_METHOD.invoke((Object)entity, new Object[0]);
            return (Integer)GET_ID_METHOD.invoke(handle, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public IndividualHologram newHologram(@Nonnull Position position, @Nonnull List<HologramLine> lines) {
        return new PacketHologram(position, lines);
    }

    static {
        try {
            Class<?> entityClass = ServerReflection.nmsClass("Entity");
            GET_ID_METHOD = entityClass.getDeclaredMethod("getId", new Class[0]);
            GET_ID_METHOD.setAccessible(true);
            Class<?> craftEntityClass = ServerReflection.obcClass("entity.CraftEntity");
            GET_HANDLE_METHOD = craftEntityClass.getDeclaredMethod("getHandle", new Class[0]);
            GET_HANDLE_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class PacketHologram
    implements IndividualHologram {
        private Position position;
        private final List<HologramLine> lines = new ArrayList<HologramLine>();
        private final List<HologramEntity> spawnedEntities = new ArrayList<HologramEntity>();
        private final Set<Player> viewers = Collections.synchronizedSet(new HashSet());
        private boolean spawned = false;
        private CompositeTerminable listeners = null;
        private Consumer<Player> clickCallback = null;

        PacketHologram(Position position, List<HologramLine> lines) {
            this.position = Objects.requireNonNull(position, "position");
            this.updateLines(lines);
        }

        private Position getNewLinePosition() {
            if (this.spawnedEntities.isEmpty()) {
                return this.position;
            }
            ArmorStand last = this.spawnedEntities.get(this.spawnedEntities.size() - 1).getArmorStand();
            return Position.of(last.getLocation()).subtract(0.0, 0.25, 0.0);
        }

        @Override
        public void spawn() {
            Object as2;
            int spawnedSize;
            int linesSize;
            if (this.listeners == null) {
                this.setupPacketListeners();
            }
            if ((linesSize = this.lines.size()) < (spawnedSize = this.spawnedEntities.size())) {
                int diff = spawnedSize - linesSize;
                for (int i = 0; i < diff; ++i) {
                    int index = this.spawnedEntities.size() - 1;
                    as2 = this.spawnedEntities.get(index).getArmorStand();
                    as2.remove();
                    this.spawnedEntities.remove(index);
                }
            }
            for (int i = 0; i < this.lines.size(); ++i) {
                HologramLine line = this.lines.get(i);
                String generatedName = "hologramline-" + ThreadLocalRandom.current().nextInt(100000000);
                if (i >= this.spawnedEntities.size()) {
                    Location loc = this.getNewLinePosition().toLocation();
                    HologramEntity holoEntity = new HologramEntity(line);
                    this.spawnedEntities.add(holoEntity);
                    Chunk chunk = loc.getChunk();
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    loc.getWorld().spawn(loc, ArmorStand.class, as -> {
                        int eid = PacketIndividualHologramFactory.getEntityId((Entity)as);
                        holoEntity.setId(eid);
                        holoEntity.setArmorStand((ArmorStand)as);
                        as.setSmall(true);
                        as.setMarker(true);
                        as.setArms(false);
                        as.setBasePlate(false);
                        as.setGravity(false);
                        as.setVisible(false);
                        as.setCustomName(generatedName);
                        as.setCustomNameVisible(true);
                        if (MinecraftVersion.getRuntimeVersion().isAfterOrEq(MinecraftVersions.v1_9)) {
                            as.setAI(false);
                            as.setCollidable(false);
                            as.setInvulnerable(true);
                        }
                    });
                    continue;
                }
                as2 = this.spawnedEntities.get(i);
                if (((HologramEntity)as2).getLine().equals(line)) continue;
                ((HologramEntity)as2).setLine(line);
                ((HologramEntity)as2).getArmorStand().setCustomName(generatedName);
            }
            this.spawned = true;
        }

        @Override
        public void despawn() {
            this.spawnedEntities.forEach(e -> e.getArmorStand().remove());
            this.spawnedEntities.clear();
            this.spawned = false;
            if (this.listeners != null) {
                this.listeners.closeAndReportException();
            }
            this.listeners = null;
        }

        @Override
        public boolean isSpawned() {
            if (!this.spawned) {
                return false;
            }
            for (HologramEntity stand : this.spawnedEntities) {
                if (stand.getArmorStand().isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updatePosition(@Nonnull Position position) {
            Objects.requireNonNull(position, "position");
            if (this.position.equals(position)) {
                return;
            }
            this.position = position;
            this.despawn();
            this.spawn();
        }

        @Override
        public void updateLines(@Nonnull List<HologramLine> lines) {
            Objects.requireNonNull(lines, "lines");
            Preconditions.checkArgument(!lines.isEmpty(), "lines cannot be empty");
            for (HologramLine line : lines) {
                Preconditions.checkArgument(line != null, "null line");
            }
            if (this.lines.equals(lines)) {
                return;
            }
            this.lines.clear();
            this.lines.addAll(lines);
        }

        @Override
        @Nonnull
        public Set<Player> getViewers() {
            return ImmutableSet.copyOf(this.viewers);
        }

        @Override
        public void addViewer(@Nonnull Player player) {
            if (!this.viewers.add(player)) {
                return;
            }
            for (HologramEntity entity : this.spawnedEntities) {
                PacketContainer spawnPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
                spawnPacket.getModifier().writeDefaults();
                spawnPacket.getIntegers().write(0, (Object)entity.getId());
                spawnPacket.getUUIDs().write(0, (Object)entity.getArmorStand().getUniqueId());
                Location loc = entity.getArmorStand().getLocation();
                spawnPacket.getDoubles().write(0, (Object)loc.getX());
                spawnPacket.getDoubles().write(1, (Object)loc.getY());
                spawnPacket.getDoubles().write(2, (Object)loc.getZ());
                spawnPacket.getIntegers().write(4, (Object)((int)(loc.getPitch() * 256.0f / 360.0f)));
                spawnPacket.getIntegers().write(5, (Object)((int)(loc.getYaw() * 256.0f / 360.0f)));
                spawnPacket.getIntegers().write(6, (Object)78);
                spawnPacket.getIntegers().write(7, (Object)0);
                Protocol.sendPacket(player, spawnPacket);
                PacketContainer metadataPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                metadataPacket.getIntegers().write(0, (Object)entity.getId());
                WrappedDataWatcher dataWatcher = new WrappedDataWatcher();
                ArrayList<WrappedWatchableObject> watchableObjects = new ArrayList<WrappedWatchableObject>();
                watchableObjects.add(new WrappedWatchableObject(2, (Object)Text.colorize(entity.getLine().resolve(player))));
                watchableObjects.add(new WrappedWatchableObject(3, (Object)true));
                for (Map.Entry<Integer, WrappedWatchableObject> ent : entity.getCachedMetadata().entrySet()) {
                    if (ent.getKey() == 2 || ent.getKey() == 3) continue;
                    watchableObjects.add(ent.getValue());
                }
                metadataPacket.getWatchableCollectionModifier().write(0, watchableObjects);
                Protocol.sendPacket(player, metadataPacket);
            }
        }

        @Override
        public void removeViewer(@Nonnull Player player) {
            if (!this.viewers.remove(player)) {
                return;
            }
            PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            int[] ids = this.spawnedEntities.stream().mapToInt(HologramEntity::getId).toArray();
            destroyPacket.getIntegerArrays().write(0, (Object)ids);
            Protocol.sendPacket(player, destroyPacket);
        }

        @Override
        public void setClickCallback(@Nullable Consumer<Player> clickCallback) {
            this.clickCallback = clickCallback;
        }

        @Override
        public void close() {
            this.despawn();
        }

        @Override
        public boolean isClosed() {
            return !this.spawned;
        }

        private HologramEntity getHologramEntity(int entityId) {
            for (HologramEntity entity : this.spawnedEntities) {
                if (entity.getId() != entityId) continue;
                return entity;
            }
            return null;
        }

        private void setupPacketListeners() {
            this.listeners = CompositeTerminable.create();
            Events.subscribe(PlayerQuitEvent.class).handler(e -> this.viewers.remove(e.getPlayer())).bindWith(this.listeners);
            Protocol.subscribe(ListenerPriority.HIGH, PacketType.Play.Server.ENTITY_METADATA).handler(e -> {
                PacketContainer packet = e.getPacket().deepClone();
                Player player = e.getPlayer();
                int entityId = (Integer)packet.getIntegers().read(0);
                HologramEntity hologram = this.getHologramEntity(entityId);
                if (hologram == null) {
                    return;
                }
                ArrayList metadata = new ArrayList((Collection)packet.getWatchableCollectionModifier().read(0));
                if (!this.viewers.contains(player)) {
                    for (WrappedWatchableObject value : metadata) {
                        if (value.getIndex() == 2) continue;
                        hologram.getCachedMetadata().put(value.getIndex(), value);
                    }
                    e.setCancelled(true);
                    return;
                }
                for (WrappedWatchableObject value : metadata) {
                    if (value.getIndex() == 2) {
                        value.setValue((Object)Text.colorize(hologram.getLine().resolve(player)));
                        continue;
                    }
                    hologram.getCachedMetadata().put(value.getIndex(), value);
                }
                if (!this.viewers.contains(player)) {
                    e.setCancelled(true);
                    return;
                }
                packet = packet.deepClone();
                packet.getWatchableCollectionModifier().write(0, metadata);
                e.setPacket(packet);
            }).bindWith(this.listeners);
            Protocol.subscribe(ListenerPriority.HIGH, PacketType.Play.Server.SPAWN_ENTITY).handler(e -> {
                PacketContainer packet = e.getPacket();
                Player player = e.getPlayer();
                int entityId = (Integer)packet.getIntegers().read(0);
                HologramEntity hologram = this.getHologramEntity(entityId);
                if (hologram == null) {
                    return;
                }
                if (!this.viewers.contains(player)) {
                    e.setCancelled(true);
                }
            }).bindWith(this.listeners);
            Protocol.subscribe(ListenerPriority.HIGH, PacketType.Play.Client.USE_ENTITY).handler(e -> {
                PacketContainer packet = e.getPacket();
                Player player = e.getPlayer();
                int entityId = (Integer)packet.getIntegers().read(0);
                HologramEntity hologram = this.getHologramEntity(entityId);
                if (hologram == null) {
                    return;
                }
                e.setCancelled(true);
                if (this.clickCallback == null) {
                    return;
                }
                if (!this.viewers.contains(player)) {
                    return;
                }
                Location location = hologram.getArmorStand().getLocation();
                if (player.getLocation().distance(location) > 5.0) {
                    return;
                }
                this.clickCallback.accept(player);
            }).bindWith(this.listeners);
        }
    }

    private static final class HologramEntity {
        private ArmorStand armorStand;
        private HologramLine line;
        private int entityId;
        private final Map<Integer, WrappedWatchableObject> cachedMetadata = new HashMap<Integer, WrappedWatchableObject>();

        private HologramEntity(HologramLine line) {
            this.line = line;
        }

        public ArmorStand getArmorStand() {
            return this.armorStand;
        }

        public void setArmorStand(ArmorStand armorStand) {
            this.armorStand = armorStand;
        }

        public HologramLine getLine() {
            return this.line;
        }

        public void setLine(HologramLine line) {
            this.line = line;
        }

        public int getId() {
            return this.entityId;
        }

        public void setId(int entityId) {
            this.entityId = entityId;
        }

        public Map<Integer, WrappedWatchableObject> getCachedMetadata() {
            return this.cachedMetadata;
        }
    }
}

