/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.holograms;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.holograms.Hologram;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public interface HologramFactory {
    @Nonnull
    public Hologram newHologram(@Nonnull Position var1, @Nonnull List<String> var2);

    @Nonnull
    default public Hologram deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("position"));
        Preconditions.checkArgument(object.has("lines"));
        Position position = Position.deserialize(object.get("position"));
        JsonArray lineArray = object.get("lines").getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (JsonElement e : lineArray) {
            lines.add(e.getAsString());
        }
        return this.newHologram(position, lines);
    }
}

