/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.events.functional.merged;

import com.google.common.reflect.TypeToken;
import io.lumine.mythic.bukkit.utils.events.MergedSubscription;
import io.lumine.mythic.bukkit.utils.events.functional.ExpiryTestStage;
import io.lumine.mythic.bukkit.utils.events.functional.merged.MergedHandlerList;
import io.lumine.mythic.bukkit.utils.events.functional.merged.MergedHandlerListImpl;
import io.lumine.mythic.bukkit.utils.events.functional.merged.MergedHandlerMapping;
import io.lumine.mythic.bukkit.utils.events.functional.merged.MergedSubscriptionBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

class MergedSubscriptionBuilderImpl<T>
implements MergedSubscriptionBuilder<T> {
    final TypeToken<T> handledClass;
    final Map<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>> mappings = new HashMap<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>>();
    BiConsumer<? super Event, Throwable> exceptionConsumer = DEFAULT_EXCEPTION_CONSUMER;
    final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
    final List<BiPredicate<MergedSubscription<T>, T>> preExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);
    final List<BiPredicate<MergedSubscription<T>, T>> midExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);
    final List<BiPredicate<MergedSubscription<T>, T>> postExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);

    MergedSubscriptionBuilderImpl(TypeToken<T> handledClass) {
        this.handledClass = handledClass;
    }

    @Override
    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> eventClass, @Nonnull Function<E, T> function) {
        return this.bindEvent(eventClass, EventPriority.NORMAL, function);
    }

    @Override
    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> eventClass, @Nonnull EventPriority priority, @Nonnull Function<E, T> function) {
        Objects.requireNonNull(eventClass, "eventClass");
        Objects.requireNonNull(priority, "priority");
        Objects.requireNonNull(function, "function");
        this.mappings.put(eventClass, new MergedHandlerMapping<T, E>(priority, function));
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> expireIf(@Nonnull BiPredicate<MergedSubscription<T>, T> predicate, ExpiryTestStage ... testPoints) {
        Objects.requireNonNull(testPoints, "testPoints");
        Objects.requireNonNull(predicate, "predicate");
        block5: for (ExpiryTestStage testPoint : testPoints) {
            switch (testPoint) {
                case PRE: {
                    this.preExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_FILTER: {
                    this.midExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_HANDLE: {
                    this.postExpiryTests.add(predicate);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ExpiryTestPoint: " + testPoint);
                }
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> filter(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.filters.add(predicate);
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> exceptionConsumer(@Nonnull BiConsumer<Event, Throwable> exceptionConsumer) {
        Objects.requireNonNull(exceptionConsumer, "exceptionConsumer");
        this.exceptionConsumer = exceptionConsumer;
        return this;
    }

    @Override
    @Nonnull
    public MergedHandlerList<T> handlers() {
        if (this.mappings.isEmpty()) {
            throw new IllegalStateException("No mappings were created");
        }
        return new MergedHandlerListImpl(this);
    }
}

