/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.IconProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.menu.EditableIcon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.hotbar.EditableHotbarMenuBuilder;
import io.lumine.mythic.bukkit.utils.menu.hotbar.HotbarMenuBuilder;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class HotbarMenuProp<T>
extends PropertyType<EditableHotbarMenuBuilder<T>> {
    private HotbarMenuBuilder<T> def;
    private StringProp SCHEMA;
    private NodeListProp ICON_NODES;

    public HotbarMenuProp(LuminePlugin plugin, Object file, String node, HotbarMenuBuilder<T> def) {
        super(plugin, file, node);
        this.SCHEMA = new StringProp(plugin, file, node + ".Schema", null);
        this.ICON_NODES = new NodeListProp(plugin, file, node + ".Icons");
        this.def = def;
    }

    @Override
    protected EditableHotbarMenuBuilder<T> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.getDefault();
        }
        HashMap icons = new HashMap();
        String schema = (String)this.SCHEMA.get(section);
        HashMap schemaMap = new HashMap();
        if (schema != null) {
            int i = 0;
            for (String key : schema.split(" ")) {
                if (!schemaMap.containsKey(key)) {
                    schemaMap.put(key, new ArrayList());
                }
                ((List)schemaMap.get(key)).add(i);
                if (++i >= 9) break;
            }
        }
        if (!schemaMap.isEmpty()) {
            for (String key : (Set)this.ICON_NODES.get(section)) {
                IconProp iconProp = new IconProp(this.plugin, this.file, node + ".Icons." + key);
                StringProp slotsProp = new StringProp(this.plugin, this.file, node + ".Icons." + key + ".Mapping");
                strSlots = (String)slotsProp.get(section);
                if (!schemaMap.containsKey(strSlots)) continue;
                List slots = (List)schemaMap.get(strSlots);
                IconBuilder iconBuilder = (IconBuilder)iconProp.get(section);
                iconProp.get(section);
                icons.put(key, new EditableIcon(iconBuilder, slots));
            }
        } else {
            for (String key : (Set)this.ICON_NODES.get(section)) {
                String[] split;
                IconProp iconProp = new IconProp(this.plugin, this.file, node + ".Icons." + key);
                StringProp slotsProp = new StringProp(this.plugin, this.file, node + ".Icons." + key + ".Slots");
                strSlots = (String)slotsProp.get(section);
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (String s2 : split = strSlots.split(",")) {
                    try {
                        int i = Integer.valueOf(s2);
                        slots.add(i);
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                    }
                }
                IconBuilder iconBuilder = (IconBuilder)iconProp.get(section);
                iconProp.get(section);
                icons.put(key, new EditableIcon(iconBuilder, slots));
            }
        }
        return new EditableHotbarMenuBuilder(HotbarMenuBuilder.create(), icons);
    }

    @Override
    public void set(String holder, EditableHotbarMenuBuilder<T> value) {
        if (this.config == null) {
            return;
        }
    }

    private EditableHotbarMenuBuilder getDefault() {
        return null;
    }
}

