/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.bossbar;

import io.lumine.mythic.bukkit.utils.bossbar.BossBar;
import io.lumine.mythic.bukkit.utils.bossbar.BossBarColor;
import io.lumine.mythic.bukkit.utils.bossbar.BossBarFactory;
import io.lumine.mythic.bukkit.utils.bossbar.BossBarStyle;
import io.lumine.mythic.bukkit.utils.text.Text;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Server;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;

public class BukkitBossBarFactory
implements BossBarFactory {
    private final Server server;

    public BukkitBossBarFactory(Server server) {
        this.server = server;
    }

    @Override
    @Nonnull
    public BossBar newBossBar() {
        return new BukkitBossBar(this.server.createBossBar("null", BukkitBossBarFactory.convertColor(BossBarColor.defaultColor()), BukkitBossBarFactory.convertStyle(BossBarStyle.defaultStyle()), new BarFlag[0]));
    }

    private static BossBarStyle convertStyle(BarStyle style) {
        switch (style) {
            case SOLID: {
                return BossBarStyle.SOLID;
            }
            case SEGMENTED_6: {
                return BossBarStyle.SEGMENTED_6;
            }
            case SEGMENTED_10: {
                return BossBarStyle.SEGMENTED_10;
            }
            case SEGMENTED_12: {
                return BossBarStyle.SEGMENTED_12;
            }
            case SEGMENTED_20: {
                return BossBarStyle.SEGMENTED_20;
            }
        }
        return BossBarStyle.defaultStyle();
    }

    private static BarStyle convertStyle(BossBarStyle style) {
        switch (style) {
            case SOLID: {
                return BarStyle.SOLID;
            }
            case SEGMENTED_6: {
                return BarStyle.SEGMENTED_6;
            }
            case SEGMENTED_10: {
                return BarStyle.SEGMENTED_10;
            }
            case SEGMENTED_12: {
                return BarStyle.SEGMENTED_12;
            }
            case SEGMENTED_20: {
                return BarStyle.SEGMENTED_20;
            }
        }
        return BukkitBossBarFactory.convertStyle(BossBarStyle.defaultStyle());
    }

    private static BossBarColor convertColor(BarColor color) {
        switch (color) {
            case PINK: {
                return BossBarColor.PINK;
            }
            case BLUE: {
                return BossBarColor.BLUE;
            }
            case RED: {
                return BossBarColor.RED;
            }
            case GREEN: {
                return BossBarColor.GREEN;
            }
            case YELLOW: {
                return BossBarColor.YELLOW;
            }
            case PURPLE: {
                return BossBarColor.PURPLE;
            }
            case WHITE: {
                return BossBarColor.WHITE;
            }
        }
        return BossBarColor.defaultColor();
    }

    private static BarColor convertColor(BossBarColor color) {
        switch (color) {
            case PINK: {
                return BarColor.PINK;
            }
            case BLUE: {
                return BarColor.BLUE;
            }
            case RED: {
                return BarColor.RED;
            }
            case GREEN: {
                return BarColor.GREEN;
            }
            case YELLOW: {
                return BarColor.YELLOW;
            }
            case PURPLE: {
                return BarColor.PURPLE;
            }
            case WHITE: {
                return BarColor.WHITE;
            }
        }
        return BukkitBossBarFactory.convertColor(BossBarColor.defaultColor());
    }

    private static class BukkitBossBar
    implements BossBar {
        private final org.bukkit.boss.BossBar bar;

        BukkitBossBar(org.bukkit.boss.BossBar bar) {
            this.bar = bar;
        }

        @Override
        @Nonnull
        public String title() {
            return this.bar.getTitle();
        }

        @Override
        @Nonnull
        public BossBar title(@Nonnull String title) {
            this.bar.setTitle(Text.colorize(title));
            return this;
        }

        @Override
        public double progress() {
            return this.bar.getProgress();
        }

        @Override
        @Nonnull
        public BossBar progress(double progress) {
            this.bar.setProgress(progress);
            return this;
        }

        @Override
        @Nonnull
        public BossBarColor color() {
            return BukkitBossBarFactory.convertColor(this.bar.getColor());
        }

        @Override
        @Nonnull
        public BossBar color(@Nonnull BossBarColor color) {
            this.bar.setColor(BukkitBossBarFactory.convertColor(color));
            return this;
        }

        @Override
        @Nonnull
        public BossBarStyle style() {
            return BukkitBossBarFactory.convertStyle(this.bar.getStyle());
        }

        @Override
        @Nonnull
        public BossBar style(@Nonnull BossBarStyle style) {
            this.bar.setStyle(BukkitBossBarFactory.convertStyle(style));
            return this;
        }

        @Override
        public boolean visible() {
            return this.bar.isVisible();
        }

        @Override
        @Nonnull
        public BossBar visible(boolean visible) {
            this.bar.setVisible(visible);
            return this;
        }

        @Override
        @Nonnull
        public List<Player> players() {
            return this.bar.getPlayers();
        }

        @Override
        public void addPlayer(@Nonnull Player player) {
            this.bar.addPlayer(player);
        }

        @Override
        public void removePlayer(@Nonnull Player player) {
            this.bar.removePlayer(player);
        }

        @Override
        public void removeAll() {
            this.bar.removeAll();
        }

        @Override
        public void close() {
            this.removeAll();
        }
    }
}

